package zio.aws.pinpoint.model
import scala.jdk.CollectionConverters.*
sealed trait AttributeType {
  def unwrap: software.amazon.awssdk.services.pinpoint.model.AttributeType
}
object AttributeType {
  def wrap(
      value: software.amazon.awssdk.services.pinpoint.model.AttributeType
  ): zio.aws.pinpoint.model.AttributeType = value match {
    case software.amazon.awssdk.services.pinpoint.model.AttributeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pinpoint.model.AttributeType.INCLUSIVE =>
      val r = INCLUSIVE
      r
    case software.amazon.awssdk.services.pinpoint.model.AttributeType.EXCLUSIVE =>
      val r = EXCLUSIVE
      r
    case software.amazon.awssdk.services.pinpoint.model.AttributeType.CONTAINS =>
      val r = CONTAINS
      r
    case software.amazon.awssdk.services.pinpoint.model.AttributeType.BEFORE =>
      val r = BEFORE
      r
    case software.amazon.awssdk.services.pinpoint.model.AttributeType.AFTER =>
      val r = AFTER
      r
    case software.amazon.awssdk.services.pinpoint.model.AttributeType.ON =>
      val r = ON
      r
    case software.amazon.awssdk.services.pinpoint.model.AttributeType.BETWEEN =>
      val r = BETWEEN
      r
  }
  case object unknownToSdkVersion extends zio.aws.pinpoint.model.AttributeType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.AttributeType =
      software.amazon.awssdk.services.pinpoint.model.AttributeType.UNKNOWN_TO_SDK_VERSION
  }
  case object INCLUSIVE extends zio.aws.pinpoint.model.AttributeType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.AttributeType =
      software.amazon.awssdk.services.pinpoint.model.AttributeType.INCLUSIVE
  }
  case object EXCLUSIVE extends zio.aws.pinpoint.model.AttributeType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.AttributeType =
      software.amazon.awssdk.services.pinpoint.model.AttributeType.EXCLUSIVE
  }
  case object CONTAINS extends zio.aws.pinpoint.model.AttributeType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.AttributeType =
      software.amazon.awssdk.services.pinpoint.model.AttributeType.CONTAINS
  }
  case object BEFORE extends zio.aws.pinpoint.model.AttributeType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.AttributeType =
      software.amazon.awssdk.services.pinpoint.model.AttributeType.BEFORE
  }
  case object AFTER extends zio.aws.pinpoint.model.AttributeType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.AttributeType =
      software.amazon.awssdk.services.pinpoint.model.AttributeType.AFTER
  }
  case object ON extends zio.aws.pinpoint.model.AttributeType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.AttributeType =
      software.amazon.awssdk.services.pinpoint.model.AttributeType.ON
  }
  case object BETWEEN extends zio.aws.pinpoint.model.AttributeType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.AttributeType =
      software.amazon.awssdk.services.pinpoint.model.AttributeType.BETWEEN
  }
}
