package zio.aws.pinpoint.model
import scala.jdk.CollectionConverters.*
sealed trait Alignment {
  def unwrap: software.amazon.awssdk.services.pinpoint.model.Alignment
}
object Alignment {
  def wrap(
      value: software.amazon.awssdk.services.pinpoint.model.Alignment
  ): zio.aws.pinpoint.model.Alignment = value match {
    case software.amazon.awssdk.services.pinpoint.model.Alignment.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pinpoint.model.Alignment.LEFT =>
      val r = LEFT
      r
    case software.amazon.awssdk.services.pinpoint.model.Alignment.CENTER =>
      val r = CENTER
      r
    case software.amazon.awssdk.services.pinpoint.model.Alignment.RIGHT =>
      val r = RIGHT
      r
  }
  case object unknownToSdkVersion extends zio.aws.pinpoint.model.Alignment {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.Alignment =
      software.amazon.awssdk.services.pinpoint.model.Alignment.UNKNOWN_TO_SDK_VERSION
  }
  case object LEFT extends zio.aws.pinpoint.model.Alignment {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.Alignment =
      software.amazon.awssdk.services.pinpoint.model.Alignment.LEFT
  }
  case object CENTER extends zio.aws.pinpoint.model.Alignment {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.Alignment =
      software.amazon.awssdk.services.pinpoint.model.Alignment.CENTER
  }
  case object RIGHT extends zio.aws.pinpoint.model.Alignment {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.Alignment =
      software.amazon.awssdk.services.pinpoint.model.Alignment.RIGHT
  }
}
