package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__boolean, __string}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ADMChannelRequest(
    clientId: __string,
    clientSecret: __string,
    enabled: Optional[__boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.ADMChannelRequest = {
    import ADMChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.ADMChannelRequest
      .builder()
      .clientId(clientId: java.lang.String)
      .clientSecret(clientSecret: java.lang.String)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.ADMChannelRequest.ReadOnly =
    zio.aws.pinpoint.model.ADMChannelRequest.wrap(buildAwsValue())
}
object ADMChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.ADMChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.ADMChannelRequest =
      zio.aws.pinpoint.model
        .ADMChannelRequest(clientId, clientSecret, enabled.map(value => value))
    def clientId: __string
    def clientSecret: __string
    def enabled: Optional[__boolean]
    def getClientId: ZIO[Any, Nothing, __string] = ZIO.succeed(clientId)
    def getClientSecret: ZIO[Any, Nothing, __string] = ZIO.succeed(clientSecret)
    def getEnabled: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.ADMChannelRequest
  ) extends zio.aws.pinpoint.model.ADMChannelRequest.ReadOnly {
    override val clientId: __string = impl.clientId(): __string
    override val clientSecret: __string = impl.clientSecret(): __string
    override val enabled: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: __boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.ADMChannelRequest
  ): zio.aws.pinpoint.model.ADMChannelRequest.ReadOnly = new Wrapper(impl)
}
