package zio.aws.pinpoint
import zio.aws.pinpoint.model.CreateExportJobResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.pinpoint.model.{
  CreateAppRequest,
  DeleteEmailChannelResponse,
  GetJourneyRequest,
  GetJourneyExecutionActivityMetricsRequest,
  UpdateApnsChannelRequest,
  UpdateVoiceChannelRequest,
  UpdateAdmChannelRequest,
  CreateEmailTemplateResponse,
  GetSegmentVersionRequest,
  CreateExportJobRequest,
  DeleteApnsVoipChannelResponse,
  GetSegmentRequest,
  SendMessagesResponse,
  DeleteGcmChannelResponse,
  GetCampaignVersionRequest,
  DeleteEmailTemplateResponse,
  CreatePushTemplateRequest,
  GetApplicationDateRangeKpiRequest,
  GetPushTemplateResponse,
  GetVoiceChannelRequest,
  DeleteEndpointRequest,
  DeletePushTemplateRequest,
  GetApnsVoipChannelRequest,
  GetApnsChannelResponse,
  CreateVoiceTemplateResponse,
  GetApnsVoipSandboxChannelRequest,
  PutEventStreamResponse,
  DeleteEndpointResponse,
  GetJourneyExecutionMetricsRequest,
  DeleteVoiceTemplateResponse,
  GetSegmentVersionsResponse,
  UpdateTemplateActiveVersionRequest,
  DeleteVoiceChannelRequest,
  CreatePushTemplateResponse,
  GetJourneyDateRangeKpiRequest,
  GetExportJobRequest,
  DeleteJourneyRequest,
  UpdateEndpointResponse,
  GetSegmentExportJobsRequest,
  CreateSegmentResponse,
  GetGcmChannelRequest,
  GetSmsChannelResponse,
  UpdateEndpointsBatchResponse,
  GetEndpointResponse,
  GetExportJobResponse,
  GetCampaignVersionResponse,
  GetApnsVoipChannelResponse,
  GetCampaignDateRangeKpiResponse,
  GetRecommenderConfigurationsResponse,
  GetPushTemplateRequest,
  CreateInAppTemplateRequest,
  GetVoiceTemplateRequest,
  ListTemplatesResponse,
  SendUsersMessagesRequest,
  VerifyOtpMessageResponse,
  RemoveAttributesRequest,
  DeleteApnsChannelRequest,
  UpdateVoiceTemplateRequest,
  UpdateEndpointsBatchRequest,
  SendUsersMessagesResponse,
  DeleteVoiceChannelResponse,
  DeleteSegmentResponse,
  UpdateVoiceTemplateResponse,
  UpdateVoiceChannelResponse,
  UpdateApnsChannelResponse,
  GetJourneyResponse,
  UpdateRecommenderConfigurationRequest,
  DeleteInAppTemplateRequest,
  GetVoiceTemplateResponse,
  DeleteApnsVoipChannelRequest,
  GetCampaignActivitiesRequest,
  CreateSmsTemplateResponse,
  UpdateApnsSandboxChannelResponse,
  ListJourneysResponse,
  CreateRecommenderConfigurationRequest,
  GetSmsTemplateResponse,
  UpdateBaiduChannelRequest,
  UpdateInAppTemplateResponse,
  GetJourneyExecutionMetricsResponse,
  SendOtpMessageRequest,
  GetExportJobsRequest,
  UpdateEndpointRequest,
  GetApnsVoipSandboxChannelResponse,
  GetEmailChannelRequest,
  GetCampaignsRequest,
  UpdateSmsTemplateResponse,
  ListTagsForResourceRequest,
  GetCampaignActivitiesResponse,
  GetImportJobResponse,
  DeleteAdmChannelRequest,
  DeleteBaiduChannelRequest,
  DeleteAdmChannelResponse,
  DeleteUserEndpointsRequest,
  GetAdmChannelResponse,
  VerifyOtpMessageRequest,
  GetChannelsResponse,
  UpdateSmsChannelRequest,
  GetJourneyRunsRequest,
  UpdateAdmChannelResponse,
  UpdatePushTemplateResponse,
  RemoveAttributesResponse,
  GetCampaignsResponse,
  GetEmailChannelResponse,
  GetExportJobsResponse,
  UpdateCampaignRequest,
  GetCampaignRequest,
  DeleteSegmentRequest,
  UpdateEmailTemplateRequest,
  ListJourneysRequest,
  GetGcmChannelResponse,
  GetUserEndpointsResponse,
  GetEmailTemplateRequest,
  DeleteUserEndpointsResponse,
  GetImportJobsRequest,
  UpdateApplicationSettingsRequest,
  GetAppResponse,
  UpdateSegmentRequest,
  UpdateInAppTemplateRequest,
  GetSegmentExportJobsResponse,
  GetSegmentsRequest,
  CreateImportJobResponse,
  GetSegmentImportJobsRequest,
  GetRecommenderConfigurationsRequest,
  ListTagsForResourceResponse,
  GetApplicationDateRangeKpiResponse,
  DeleteApnsSandboxChannelResponse,
  GetBaiduChannelRequest,
  UntagResourceResponse,
  ListTemplateVersionsRequest,
  DeleteSmsChannelResponse,
  GetApplicationSettingsResponse,
  GetSegmentVersionsRequest,
  UpdateSegmentResponse,
  UpdateApnsVoipSandboxChannelRequest,
  UpdateGcmChannelRequest,
  DeleteGcmChannelRequest,
  UpdateApnsSandboxChannelRequest,
  GetJourneyRunsResponse,
  UpdateSmsTemplateRequest,
  DeleteSmsTemplateRequest,
  GetVoiceChannelResponse,
  GetJourneyExecutionActivityMetricsResponse,
  DeleteSmsChannelRequest,
  SendOtpMessageResponse,
  CreateVoiceTemplateRequest,
  CreateCampaignRequest,
  GetCampaignVersionsRequest,
  GetJourneyRunExecutionActivityMetricsRequest,
  GetInAppTemplateRequest,
  GetApnsChannelRequest,
  GetRecommenderConfigurationResponse,
  UpdateSmsChannelResponse,
  CreateJourneyResponse,
  DeleteSmsTemplateResponse,
  DeleteCampaignRequest,
  UpdatePushTemplateRequest,
  GetEndpointRequest,
  GetApnsSandboxChannelRequest,
  GetEventStreamRequest,
  UpdateJourneyRequest,
  UpdateJourneyStateResponse,
  UpdateApplicationSettingsResponse,
  GetSegmentResponse,
  GetCampaignVersionsResponse,
  GetJourneyRunExecutionMetricsRequest,
  GetAppRequest,
  GetInAppTemplateResponse,
  UpdateApnsVoipChannelResponse,
  UpdateEmailChannelResponse,
  PutEventsResponse,
  UpdateJourneyResponse,
  GetImportJobRequest,
  DeleteEmailTemplateRequest,
  ListTemplateVersionsResponse,
  GetAppsRequest,
  DeleteEventStreamResponse,
  UpdateApnsVoipChannelRequest,
  UntagResourceRequest,
  DeleteApnsVoipSandboxChannelResponse,
  PutEventsRequest,
  CreateSegmentRequest,
  GetCampaignResponse,
  DeleteRecommenderConfigurationRequest,
  GetEventStreamResponse,
  DeletePushTemplateResponse,
  DeleteAppResponse,
  CreateRecommenderConfigurationResponse,
  GetJourneyRunExecutionMetricsResponse,
  DeleteInAppTemplateResponse,
  GetAdmChannelRequest,
  GetSegmentsResponse,
  CreateJourneyRequest,
  DeleteCampaignResponse,
  GetChannelsRequest,
  CreateCampaignResponse,
  UpdateCampaignResponse,
  GetImportJobsResponse,
  CreateEmailTemplateRequest,
  GetJourneyDateRangeKpiResponse,
  GetApplicationSettingsRequest,
  DeleteEmailChannelRequest,
  GetSmsChannelRequest,
  CreateSmsTemplateRequest,
  GetInAppMessagesRequest,
  ListTemplatesRequest,
  SendMessagesRequest,
  CreateInAppTemplateResponse,
  GetSegmentImportJobsResponse,
  DeleteVoiceTemplateRequest,
  PutEventStreamRequest,
  GetRecommenderConfigurationRequest,
  DeleteRecommenderConfigurationResponse,
  GetAppsResponse,
  DeleteBaiduChannelResponse,
  GetSmsTemplateRequest,
  GetSegmentVersionResponse,
  DeleteAppRequest,
  UpdateEmailChannelRequest,
  CreateImportJobRequest,
  GetJourneyRunExecutionActivityMetricsResponse,
  TagResourceResponse,
  CreateAppResponse,
  GetCampaignDateRangeKpiRequest,
  UpdateApnsVoipSandboxChannelResponse,
  GetInAppMessagesResponse,
  GetEmailTemplateResponse,
  DeleteJourneyResponse,
  DeleteApnsChannelResponse,
  DeleteEventStreamRequest,
  UpdateEmailTemplateResponse,
  UpdateTemplateActiveVersionResponse,
  DeleteApnsVoipSandboxChannelRequest,
  PhoneNumberValidateResponse,
  PhoneNumberValidateRequest,
  TagResourceRequest,
  GetApnsSandboxChannelResponse,
  GetUserEndpointsRequest,
  GetBaiduChannelResponse,
  DeleteApnsSandboxChannelRequest,
  UpdateBaiduChannelResponse,
  UpdateJourneyStateRequest,
  UpdateRecommenderConfigurationResponse,
  CreateExportJobResponse,
  UpdateGcmChannelResponse
}
import software.amazon.awssdk.services.pinpoint.{
  PinpointAsyncClientBuilder,
  PinpointAsyncClient
}
import scala.jdk.CollectionConverters.*
trait Pinpoint extends AspectSupport[Pinpoint] {
  val api: PinpointAsyncClient
  def deleteSegment(
      request: zio.aws.pinpoint.model.DeleteSegmentRequest
  ): IO[AwsError, zio.aws.pinpoint.model.DeleteSegmentResponse.ReadOnly]
  def getInAppMessages(
      request: zio.aws.pinpoint.model.GetInAppMessagesRequest
  ): IO[AwsError, zio.aws.pinpoint.model.GetInAppMessagesResponse.ReadOnly]
  def getEndpoint(
      request: zio.aws.pinpoint.model.GetEndpointRequest
  ): IO[AwsError, zio.aws.pinpoint.model.GetEndpointResponse.ReadOnly]
  def getEventStream(
      request: zio.aws.pinpoint.model.GetEventStreamRequest
  ): IO[AwsError, zio.aws.pinpoint.model.GetEventStreamResponse.ReadOnly]
  def getEmailChannel(
      request: zio.aws.pinpoint.model.GetEmailChannelRequest
  ): IO[AwsError, zio.aws.pinpoint.model.GetEmailChannelResponse.ReadOnly]
  def updateEndpointsBatch(
      request: zio.aws.pinpoint.model.UpdateEndpointsBatchRequest
  ): IO[AwsError, zio.aws.pinpoint.model.UpdateEndpointsBatchResponse.ReadOnly]
  def getJourneyRuns(
      request: zio.aws.pinpoint.model.GetJourneyRunsRequest
  ): IO[AwsError, zio.aws.pinpoint.model.GetJourneyRunsResponse.ReadOnly]
  def getApps(
      request: zio.aws.pinpoint.model.GetAppsRequest
  ): IO[AwsError, zio.aws.pinpoint.model.GetAppsResponse.ReadOnly]
  def sendMessages(
      request: zio.aws.pinpoint.model.SendMessagesRequest
  ): IO[AwsError, zio.aws.pinpoint.model.SendMessagesResponse.ReadOnly]
  def getApplicationSettings(
      request: zio.aws.pinpoint.model.GetApplicationSettingsRequest
  ): IO[
    AwsError,
    zio.aws.pinpoint.model.GetApplicationSettingsResponse.ReadOnly
  ]
  def getSegmentVersion(
      request: zio.aws.pinpoint.model.GetSegmentVersionRequest
  ): IO[AwsError, zio.aws.pinpoint.model.GetSegmentVersionResponse.ReadOnly]
  def deleteCampaign(
      request: zio.aws.pinpoint.model.DeleteCampaignRequest
  ): IO[AwsError, zio.aws.pinpoint.model.DeleteCampaignResponse.ReadOnly]
  def getCampaign(
      request: zio.aws.pinpoint.model.GetCampaignRequest
  ): IO[AwsError, zio.aws.pinpoint.model.GetCampaignResponse.ReadOnly]
  def getUserEndpoints(
      request: zio.aws.pinpoint.model.GetUserEndpointsRequest
  ): IO[AwsError, zio.aws.pinpoint.model.GetUserEndpointsResponse.ReadOnly]
  def getApp(
      request: zio.aws.pinpoint.model.GetAppRequest
  ): IO[AwsError, zio.aws.pinpoint.model.GetAppResponse.ReadOnly]
  def getCampaignDateRangeKpi(
      request: zio.aws.pinpoint.model.GetCampaignDateRangeKpiRequest
  ): IO[
    AwsError,
    zio.aws.pinpoint.model.GetCampaignDateRangeKpiResponse.ReadOnly
  ]
  def deleteApnsSandboxChannel(
      request: zio.aws.pinpoint.model.DeleteApnsSandboxChannelRequest
  ): IO[
    AwsError,
    zio.aws.pinpoint.model.DeleteApnsSandboxChannelResponse.ReadOnly
  ]
  def getAdmChannel(
      request: zio.aws.pinpoint.model.GetAdmChannelRequest
  ): IO[AwsError, zio.aws.pinpoint.model.GetAdmChannelResponse.ReadOnly]
  def getJourneyExecutionActivityMetrics(
      request: zio.aws.pinpoint.model.GetJourneyExecutionActivityMetricsRequest
  ): IO[
    AwsError,
    zio.aws.pinpoint.model.GetJourneyExecutionActivityMetricsResponse.ReadOnly
  ]
  def updateApnsSandboxChannel(
      request: zio.aws.pinpoint.model.UpdateApnsSandboxChannelRequest
  ): IO[
    AwsError,
    zio.aws.pinpoint.model.UpdateApnsSandboxChannelResponse.ReadOnly
  ]
  def getApnsChannel(
      request: zio.aws.pinpoint.model.GetApnsChannelRequest
  ): IO[AwsError, zio.aws.pinpoint.model.GetApnsChannelResponse.ReadOnly]
  def getEmailTemplate(
      request: zio.aws.pinpoint.model.GetEmailTemplateRequest
  ): IO[AwsError, zio.aws.pinpoint.model.GetEmailTemplateResponse.ReadOnly]
  def listJourneys(
      request: zio.aws.pinpoint.model.ListJourneysRequest
  ): IO[AwsError, zio.aws.pinpoint.model.ListJourneysResponse.ReadOnly]
  def sendOTPMessage(
      request: zio.aws.pinpoint.model.SendOtpMessageRequest
  ): IO[AwsError, zio.aws.pinpoint.model.SendOtpMessageResponse.ReadOnly]
  def createEmailTemplate(
      request: zio.aws.pinpoint.model.CreateEmailTemplateRequest
  ): IO[AwsError, zio.aws.pinpoint.model.CreateEmailTemplateResponse.ReadOnly]
  def removeAttributes(
      request: zio.aws.pinpoint.model.RemoveAttributesRequest
  ): IO[AwsError, zio.aws.pinpoint.model.RemoveAttributesResponse.ReadOnly]
  def createPushTemplate(
      request: zio.aws.pinpoint.model.CreatePushTemplateRequest
  ): IO[AwsError, zio.aws.pinpoint.model.CreatePushTemplateResponse.ReadOnly]
  def getCampaignVersion(
      request: zio.aws.pinpoint.model.GetCampaignVersionRequest
  ): IO[AwsError, zio.aws.pinpoint.model.GetCampaignVersionResponse.ReadOnly]
  def updateSegment(
      request: zio.aws.pinpoint.model.UpdateSegmentRequest
  ): IO[AwsError, zio.aws.pinpoint.model.UpdateSegmentResponse.ReadOnly]
  def getCampaignVersions(
      request: zio.aws.pinpoint.model.GetCampaignVersionsRequest
  ): IO[AwsError, zio.aws.pinpoint.model.GetCampaignVersionsResponse.ReadOnly]
  def updateBaiduChannel(
      request: zio.aws.pinpoint.model.UpdateBaiduChannelRequest
  ): IO[AwsError, zio.aws.pinpoint.model.UpdateBaiduChannelResponse.ReadOnly]
  def createSmsTemplate(
      request: zio.aws.pinpoint.model.CreateSmsTemplateRequest
  ): IO[AwsError, zio.aws.pinpoint.model.CreateSmsTemplateResponse.ReadOnly]
  def createJourney(
      request: zio.aws.pinpoint.model.CreateJourneyRequest
  ): IO[AwsError, zio.aws.pinpoint.model.CreateJourneyResponse.ReadOnly]
  def getImportJobs(
      request: zio.aws.pinpoint.model.GetImportJobsRequest
  ): IO[AwsError, zio.aws.pinpoint.model.GetImportJobsResponse.ReadOnly]
  def getExportJob(
      request: zio.aws.pinpoint.model.GetExportJobRequest
  ): IO[AwsError, zio.aws.pinpoint.model.GetExportJobResponse.ReadOnly]
  def getJourneyRunExecutionMetrics(
      request: zio.aws.pinpoint.model.GetJourneyRunExecutionMetricsRequest
  ): IO[
    AwsError,
    zio.aws.pinpoint.model.GetJourneyRunExecutionMetricsResponse.ReadOnly
  ]
  def getCampaigns(
      request: zio.aws.pinpoint.model.GetCampaignsRequest
  ): IO[AwsError, zio.aws.pinpoint.model.GetCampaignsResponse.ReadOnly]
  def updateApplicationSettings(
      request: zio.aws.pinpoint.model.UpdateApplicationSettingsRequest
  ): IO[
    AwsError,
    zio.aws.pinpoint.model.UpdateApplicationSettingsResponse.ReadOnly
  ]
  def getVoiceChannel(
      request: zio.aws.pinpoint.model.GetVoiceChannelRequest
  ): IO[AwsError, zio.aws.pinpoint.model.GetVoiceChannelResponse.ReadOnly]
  def getSmsTemplate(
      request: zio.aws.pinpoint.model.GetSmsTemplateRequest
  ): IO[AwsError, zio.aws.pinpoint.model.GetSmsTemplateResponse.ReadOnly]
  def updateEmailChannel(
      request: zio.aws.pinpoint.model.UpdateEmailChannelRequest
  ): IO[AwsError, zio.aws.pinpoint.model.UpdateEmailChannelResponse.ReadOnly]
  def getSegmentImportJobs(
      request: zio.aws.pinpoint.model.GetSegmentImportJobsRequest
  ): IO[AwsError, zio.aws.pinpoint.model.GetSegmentImportJobsResponse.ReadOnly]
  def phoneNumberValidate(
      request: zio.aws.pinpoint.model.PhoneNumberValidateRequest
  ): IO[AwsError, zio.aws.pinpoint.model.PhoneNumberValidateResponse.ReadOnly]
  def deleteEventStream(
      request: zio.aws.pinpoint.model.DeleteEventStreamRequest
  ): IO[AwsError, zio.aws.pinpoint.model.DeleteEventStreamResponse.ReadOnly]
  def deleteAdmChannel(
      request: zio.aws.pinpoint.model.DeleteAdmChannelRequest
  ): IO[AwsError, zio.aws.pinpoint.model.DeleteAdmChannelResponse.ReadOnly]
  def getJourneyRunExecutionActivityMetrics(
      request: zio.aws.pinpoint.model.GetJourneyRunExecutionActivityMetricsRequest
  ): IO[
    AwsError,
    zio.aws.pinpoint.model.GetJourneyRunExecutionActivityMetricsResponse.ReadOnly
  ]
  def updateInAppTemplate(
      request: zio.aws.pinpoint.model.UpdateInAppTemplateRequest
  ): IO[AwsError, zio.aws.pinpoint.model.UpdateInAppTemplateResponse.ReadOnly]
  def getChannels(
      request: zio.aws.pinpoint.model.GetChannelsRequest
  ): IO[AwsError, zio.aws.pinpoint.model.GetChannelsResponse.ReadOnly]
  def updateApnsChannel(
      request: zio.aws.pinpoint.model.UpdateApnsChannelRequest
  ): IO[AwsError, zio.aws.pinpoint.model.UpdateApnsChannelResponse.ReadOnly]
  def getGcmChannel(
      request: zio.aws.pinpoint.model.GetGcmChannelRequest
  ): IO[AwsError, zio.aws.pinpoint.model.GetGcmChannelResponse.ReadOnly]
  def deleteJourney(
      request: zio.aws.pinpoint.model.DeleteJourneyRequest
  ): IO[AwsError, zio.aws.pinpoint.model.DeleteJourneyResponse.ReadOnly]
  def getApnsVoipSandboxChannel(
      request: zio.aws.pinpoint.model.GetApnsVoipSandboxChannelRequest
  ): IO[
    AwsError,
    zio.aws.pinpoint.model.GetApnsVoipSandboxChannelResponse.ReadOnly
  ]
  def putEvents(
      request: zio.aws.pinpoint.model.PutEventsRequest
  ): IO[AwsError, zio.aws.pinpoint.model.PutEventsResponse.ReadOnly]
  def deleteSmsChannel(
      request: zio.aws.pinpoint.model.DeleteSmsChannelRequest
  ): IO[AwsError, zio.aws.pinpoint.model.DeleteSmsChannelResponse.ReadOnly]
  def createApp(
      request: zio.aws.pinpoint.model.CreateAppRequest
  ): IO[AwsError, zio.aws.pinpoint.model.CreateAppResponse.ReadOnly]
  def updateRecommenderConfiguration(
      request: zio.aws.pinpoint.model.UpdateRecommenderConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.pinpoint.model.UpdateRecommenderConfigurationResponse.ReadOnly
  ]
  def updateGcmChannel(
      request: zio.aws.pinpoint.model.UpdateGcmChannelRequest
  ): IO[AwsError, zio.aws.pinpoint.model.UpdateGcmChannelResponse.ReadOnly]
  def deleteEndpoint(
      request: zio.aws.pinpoint.model.DeleteEndpointRequest
  ): IO[AwsError, zio.aws.pinpoint.model.DeleteEndpointResponse.ReadOnly]
  def listTemplates(
      request: zio.aws.pinpoint.model.ListTemplatesRequest
  ): IO[AwsError, zio.aws.pinpoint.model.ListTemplatesResponse.ReadOnly]
  def updatePushTemplate(
      request: zio.aws.pinpoint.model.UpdatePushTemplateRequest
  ): IO[AwsError, zio.aws.pinpoint.model.UpdatePushTemplateResponse.ReadOnly]
  def updateVoiceChannel(
      request: zio.aws.pinpoint.model.UpdateVoiceChannelRequest
  ): IO[AwsError, zio.aws.pinpoint.model.UpdateVoiceChannelResponse.ReadOnly]
  def listTemplateVersions(
      request: zio.aws.pinpoint.model.ListTemplateVersionsRequest
  ): IO[AwsError, zio.aws.pinpoint.model.ListTemplateVersionsResponse.ReadOnly]
  def updateJourney(
      request: zio.aws.pinpoint.model.UpdateJourneyRequest
  ): IO[AwsError, zio.aws.pinpoint.model.UpdateJourneyResponse.ReadOnly]
  def deleteSmsTemplate(
      request: zio.aws.pinpoint.model.DeleteSmsTemplateRequest
  ): IO[AwsError, zio.aws.pinpoint.model.DeleteSmsTemplateResponse.ReadOnly]
  def createInAppTemplate(
      request: zio.aws.pinpoint.model.CreateInAppTemplateRequest
  ): IO[AwsError, zio.aws.pinpoint.model.CreateInAppTemplateResponse.ReadOnly]
  def getInAppTemplate(
      request: zio.aws.pinpoint.model.GetInAppTemplateRequest
  ): IO[AwsError, zio.aws.pinpoint.model.GetInAppTemplateResponse.ReadOnly]
  def getSegmentExportJobs(
      request: zio.aws.pinpoint.model.GetSegmentExportJobsRequest
  ): IO[AwsError, zio.aws.pinpoint.model.GetSegmentExportJobsResponse.ReadOnly]
  def getSegment(
      request: zio.aws.pinpoint.model.GetSegmentRequest
  ): IO[AwsError, zio.aws.pinpoint.model.GetSegmentResponse.ReadOnly]
  def createImportJob(
      request: zio.aws.pinpoint.model.CreateImportJobRequest
  ): IO[AwsError, zio.aws.pinpoint.model.CreateImportJobResponse.ReadOnly]
  def deleteApp(
      request: zio.aws.pinpoint.model.DeleteAppRequest
  ): IO[AwsError, zio.aws.pinpoint.model.DeleteAppResponse.ReadOnly]
  def createExportJob(
      request: zio.aws.pinpoint.model.CreateExportJobRequest
  ): IO[AwsError, ReadOnly]
  def updateApnsVoipSandboxChannel(
      request: zio.aws.pinpoint.model.UpdateApnsVoipSandboxChannelRequest
  ): IO[
    AwsError,
    zio.aws.pinpoint.model.UpdateApnsVoipSandboxChannelResponse.ReadOnly
  ]
  def createRecommenderConfiguration(
      request: zio.aws.pinpoint.model.CreateRecommenderConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.pinpoint.model.CreateRecommenderConfigurationResponse.ReadOnly
  ]
  def untagResource(
      request: zio.aws.pinpoint.model.UntagResourceRequest
  ): IO[AwsError, Unit]
  def updateSmsTemplate(
      request: zio.aws.pinpoint.model.UpdateSmsTemplateRequest
  ): IO[AwsError, zio.aws.pinpoint.model.UpdateSmsTemplateResponse.ReadOnly]
  def getCampaignActivities(
      request: zio.aws.pinpoint.model.GetCampaignActivitiesRequest
  ): IO[AwsError, zio.aws.pinpoint.model.GetCampaignActivitiesResponse.ReadOnly]
  def getApnsSandboxChannel(
      request: zio.aws.pinpoint.model.GetApnsSandboxChannelRequest
  ): IO[AwsError, zio.aws.pinpoint.model.GetApnsSandboxChannelResponse.ReadOnly]
  def updateAdmChannel(
      request: zio.aws.pinpoint.model.UpdateAdmChannelRequest
  ): IO[AwsError, zio.aws.pinpoint.model.UpdateAdmChannelResponse.ReadOnly]
  def deleteEmailTemplate(
      request: zio.aws.pinpoint.model.DeleteEmailTemplateRequest
  ): IO[AwsError, zio.aws.pinpoint.model.DeleteEmailTemplateResponse.ReadOnly]
  def getVoiceTemplate(
      request: zio.aws.pinpoint.model.GetVoiceTemplateRequest
  ): IO[AwsError, zio.aws.pinpoint.model.GetVoiceTemplateResponse.ReadOnly]
  def deleteVoiceChannel(
      request: zio.aws.pinpoint.model.DeleteVoiceChannelRequest
  ): IO[AwsError, zio.aws.pinpoint.model.DeleteVoiceChannelResponse.ReadOnly]
  def getApnsVoipChannel(
      request: zio.aws.pinpoint.model.GetApnsVoipChannelRequest
  ): IO[AwsError, zio.aws.pinpoint.model.GetApnsVoipChannelResponse.ReadOnly]
  def createSegment(
      request: zio.aws.pinpoint.model.CreateSegmentRequest
  ): IO[AwsError, zio.aws.pinpoint.model.CreateSegmentResponse.ReadOnly]
  def deleteEmailChannel(
      request: zio.aws.pinpoint.model.DeleteEmailChannelRequest
  ): IO[AwsError, zio.aws.pinpoint.model.DeleteEmailChannelResponse.ReadOnly]
  def getJourneyExecutionMetrics(
      request: zio.aws.pinpoint.model.GetJourneyExecutionMetricsRequest
  ): IO[
    AwsError,
    zio.aws.pinpoint.model.GetJourneyExecutionMetricsResponse.ReadOnly
  ]
  def updateTemplateActiveVersion(
      request: zio.aws.pinpoint.model.UpdateTemplateActiveVersionRequest
  ): IO[
    AwsError,
    zio.aws.pinpoint.model.UpdateTemplateActiveVersionResponse.ReadOnly
  ]
  def getJourneyDateRangeKpi(
      request: zio.aws.pinpoint.model.GetJourneyDateRangeKpiRequest
  ): IO[
    AwsError,
    zio.aws.pinpoint.model.GetJourneyDateRangeKpiResponse.ReadOnly
  ]
  def getJourney(
      request: zio.aws.pinpoint.model.GetJourneyRequest
  ): IO[AwsError, zio.aws.pinpoint.model.GetJourneyResponse.ReadOnly]
  def updateVoiceTemplate(
      request: zio.aws.pinpoint.model.UpdateVoiceTemplateRequest
  ): IO[AwsError, zio.aws.pinpoint.model.UpdateVoiceTemplateResponse.ReadOnly]
  def deleteApnsVoipSandboxChannel(
      request: zio.aws.pinpoint.model.DeleteApnsVoipSandboxChannelRequest
  ): IO[
    AwsError,
    zio.aws.pinpoint.model.DeleteApnsVoipSandboxChannelResponse.ReadOnly
  ]
  def getApplicationDateRangeKpi(
      request: zio.aws.pinpoint.model.GetApplicationDateRangeKpiRequest
  ): IO[
    AwsError,
    zio.aws.pinpoint.model.GetApplicationDateRangeKpiResponse.ReadOnly
  ]
  def createCampaign(
      request: zio.aws.pinpoint.model.CreateCampaignRequest
  ): IO[AwsError, zio.aws.pinpoint.model.CreateCampaignResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.pinpoint.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.pinpoint.model.ListTagsForResourceResponse.ReadOnly]
  def getSegments(
      request: zio.aws.pinpoint.model.GetSegmentsRequest
  ): IO[AwsError, zio.aws.pinpoint.model.GetSegmentsResponse.ReadOnly]
  def updateEmailTemplate(
      request: zio.aws.pinpoint.model.UpdateEmailTemplateRequest
  ): IO[AwsError, zio.aws.pinpoint.model.UpdateEmailTemplateResponse.ReadOnly]
  def getExportJobs(
      request: zio.aws.pinpoint.model.GetExportJobsRequest
  ): IO[AwsError, zio.aws.pinpoint.model.GetExportJobsResponse.ReadOnly]
  def updateJourneyState(
      request: zio.aws.pinpoint.model.UpdateJourneyStateRequest
  ): IO[AwsError, zio.aws.pinpoint.model.UpdateJourneyStateResponse.ReadOnly]
  def tagResource(
      request: zio.aws.pinpoint.model.TagResourceRequest
  ): IO[AwsError, Unit]
  def getSmsChannel(
      request: zio.aws.pinpoint.model.GetSmsChannelRequest
  ): IO[AwsError, zio.aws.pinpoint.model.GetSmsChannelResponse.ReadOnly]
  def deleteInAppTemplate(
      request: zio.aws.pinpoint.model.DeleteInAppTemplateRequest
  ): IO[AwsError, zio.aws.pinpoint.model.DeleteInAppTemplateResponse.ReadOnly]
  def deleteRecommenderConfiguration(
      request: zio.aws.pinpoint.model.DeleteRecommenderConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.pinpoint.model.DeleteRecommenderConfigurationResponse.ReadOnly
  ]
  def updateEndpoint(
      request: zio.aws.pinpoint.model.UpdateEndpointRequest
  ): IO[AwsError, zio.aws.pinpoint.model.UpdateEndpointResponse.ReadOnly]
  def deleteApnsChannel(
      request: zio.aws.pinpoint.model.DeleteApnsChannelRequest
  ): IO[AwsError, zio.aws.pinpoint.model.DeleteApnsChannelResponse.ReadOnly]
  def deleteApnsVoipChannel(
      request: zio.aws.pinpoint.model.DeleteApnsVoipChannelRequest
  ): IO[AwsError, zio.aws.pinpoint.model.DeleteApnsVoipChannelResponse.ReadOnly]
  def deletePushTemplate(
      request: zio.aws.pinpoint.model.DeletePushTemplateRequest
  ): IO[AwsError, zio.aws.pinpoint.model.DeletePushTemplateResponse.ReadOnly]
  def updateApnsVoipChannel(
      request: zio.aws.pinpoint.model.UpdateApnsVoipChannelRequest
  ): IO[AwsError, zio.aws.pinpoint.model.UpdateApnsVoipChannelResponse.ReadOnly]
  def getPushTemplate(
      request: zio.aws.pinpoint.model.GetPushTemplateRequest
  ): IO[AwsError, zio.aws.pinpoint.model.GetPushTemplateResponse.ReadOnly]
  def getImportJob(
      request: zio.aws.pinpoint.model.GetImportJobRequest
  ): IO[AwsError, zio.aws.pinpoint.model.GetImportJobResponse.ReadOnly]
  def getRecommenderConfiguration(
      request: zio.aws.pinpoint.model.GetRecommenderConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.pinpoint.model.GetRecommenderConfigurationResponse.ReadOnly
  ]
  def sendUsersMessages(
      request: zio.aws.pinpoint.model.SendUsersMessagesRequest
  ): IO[AwsError, zio.aws.pinpoint.model.SendUsersMessagesResponse.ReadOnly]
  def deleteUserEndpoints(
      request: zio.aws.pinpoint.model.DeleteUserEndpointsRequest
  ): IO[AwsError, zio.aws.pinpoint.model.DeleteUserEndpointsResponse.ReadOnly]
  def updateSmsChannel(
      request: zio.aws.pinpoint.model.UpdateSmsChannelRequest
  ): IO[AwsError, zio.aws.pinpoint.model.UpdateSmsChannelResponse.ReadOnly]
  def getSegmentVersions(
      request: zio.aws.pinpoint.model.GetSegmentVersionsRequest
  ): IO[AwsError, zio.aws.pinpoint.model.GetSegmentVersionsResponse.ReadOnly]
  def createVoiceTemplate(
      request: zio.aws.pinpoint.model.CreateVoiceTemplateRequest
  ): IO[AwsError, zio.aws.pinpoint.model.CreateVoiceTemplateResponse.ReadOnly]
  def putEventStream(
      request: zio.aws.pinpoint.model.PutEventStreamRequest
  ): IO[AwsError, zio.aws.pinpoint.model.PutEventStreamResponse.ReadOnly]
  def deleteBaiduChannel(
      request: zio.aws.pinpoint.model.DeleteBaiduChannelRequest
  ): IO[AwsError, zio.aws.pinpoint.model.DeleteBaiduChannelResponse.ReadOnly]
  def deleteGcmChannel(
      request: zio.aws.pinpoint.model.DeleteGcmChannelRequest
  ): IO[AwsError, zio.aws.pinpoint.model.DeleteGcmChannelResponse.ReadOnly]
  def verifyOTPMessage(
      request: zio.aws.pinpoint.model.VerifyOtpMessageRequest
  ): IO[AwsError, zio.aws.pinpoint.model.VerifyOtpMessageResponse.ReadOnly]
  def deleteVoiceTemplate(
      request: zio.aws.pinpoint.model.DeleteVoiceTemplateRequest
  ): IO[AwsError, zio.aws.pinpoint.model.DeleteVoiceTemplateResponse.ReadOnly]
  def getRecommenderConfigurations(
      request: zio.aws.pinpoint.model.GetRecommenderConfigurationsRequest
  ): IO[
    AwsError,
    zio.aws.pinpoint.model.GetRecommenderConfigurationsResponse.ReadOnly
  ]
  def getBaiduChannel(
      request: zio.aws.pinpoint.model.GetBaiduChannelRequest
  ): IO[AwsError, zio.aws.pinpoint.model.GetBaiduChannelResponse.ReadOnly]
  def updateCampaign(
      request: zio.aws.pinpoint.model.UpdateCampaignRequest
  ): IO[AwsError, zio.aws.pinpoint.model.UpdateCampaignResponse.ReadOnly]
}
object Pinpoint {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Pinpoint] = customized(
    identity
  )
  def customized(
      customization: PinpointAsyncClientBuilder => PinpointAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Pinpoint] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: PinpointAsyncClientBuilder => PinpointAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Pinpoint] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = PinpointAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[PinpointAsyncClient, PinpointAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[PinpointAsyncClient, PinpointAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new PinpointImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class PinpointImpl[R](
      override val api: PinpointAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Pinpoint
      with AwsServiceBase[R] {
    override val serviceName: String = "Pinpoint"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): PinpointImpl[R1] = new PinpointImpl(api, newAspect, r)
    def deleteSegment(
        request: zio.aws.pinpoint.model.DeleteSegmentRequest
    ): IO[AwsError, zio.aws.pinpoint.model.DeleteSegmentResponse.ReadOnly] =
      asyncRequestResponse[DeleteSegmentRequest, DeleteSegmentResponse](
        "deleteSegment",
        api.deleteSegment
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.DeleteSegmentResponse.wrap)
        .provideEnvironment(r)
    def getInAppMessages(
        request: zio.aws.pinpoint.model.GetInAppMessagesRequest
    ): IO[AwsError, zio.aws.pinpoint.model.GetInAppMessagesResponse.ReadOnly] =
      asyncRequestResponse[GetInAppMessagesRequest, GetInAppMessagesResponse](
        "getInAppMessages",
        api.getInAppMessages
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.GetInAppMessagesResponse.wrap)
        .provideEnvironment(r)
    def getEndpoint(
        request: zio.aws.pinpoint.model.GetEndpointRequest
    ): IO[AwsError, zio.aws.pinpoint.model.GetEndpointResponse.ReadOnly] =
      asyncRequestResponse[GetEndpointRequest, GetEndpointResponse](
        "getEndpoint",
        api.getEndpoint
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.GetEndpointResponse.wrap)
        .provideEnvironment(r)
    def getEventStream(
        request: zio.aws.pinpoint.model.GetEventStreamRequest
    ): IO[AwsError, zio.aws.pinpoint.model.GetEventStreamResponse.ReadOnly] =
      asyncRequestResponse[GetEventStreamRequest, GetEventStreamResponse](
        "getEventStream",
        api.getEventStream
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.GetEventStreamResponse.wrap)
        .provideEnvironment(r)
    def getEmailChannel(
        request: zio.aws.pinpoint.model.GetEmailChannelRequest
    ): IO[AwsError, zio.aws.pinpoint.model.GetEmailChannelResponse.ReadOnly] =
      asyncRequestResponse[GetEmailChannelRequest, GetEmailChannelResponse](
        "getEmailChannel",
        api.getEmailChannel
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.GetEmailChannelResponse.wrap)
        .provideEnvironment(r)
    def updateEndpointsBatch(
        request: zio.aws.pinpoint.model.UpdateEndpointsBatchRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.UpdateEndpointsBatchResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateEndpointsBatchRequest,
      UpdateEndpointsBatchResponse
    ]("updateEndpointsBatch", api.updateEndpointsBatch)(request.buildAwsValue())
      .map(zio.aws.pinpoint.model.UpdateEndpointsBatchResponse.wrap)
      .provideEnvironment(r)
    def getJourneyRuns(
        request: zio.aws.pinpoint.model.GetJourneyRunsRequest
    ): IO[AwsError, zio.aws.pinpoint.model.GetJourneyRunsResponse.ReadOnly] =
      asyncRequestResponse[GetJourneyRunsRequest, GetJourneyRunsResponse](
        "getJourneyRuns",
        api.getJourneyRuns
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.GetJourneyRunsResponse.wrap)
        .provideEnvironment(r)
    def getApps(
        request: zio.aws.pinpoint.model.GetAppsRequest
    ): IO[AwsError, zio.aws.pinpoint.model.GetAppsResponse.ReadOnly] =
      asyncRequestResponse[GetAppsRequest, GetAppsResponse](
        "getApps",
        api.getApps
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.GetAppsResponse.wrap)
        .provideEnvironment(r)
    def sendMessages(
        request: zio.aws.pinpoint.model.SendMessagesRequest
    ): IO[AwsError, zio.aws.pinpoint.model.SendMessagesResponse.ReadOnly] =
      asyncRequestResponse[SendMessagesRequest, SendMessagesResponse](
        "sendMessages",
        api.sendMessages
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.SendMessagesResponse.wrap)
        .provideEnvironment(r)
    def getApplicationSettings(
        request: zio.aws.pinpoint.model.GetApplicationSettingsRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.GetApplicationSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetApplicationSettingsRequest,
      GetApplicationSettingsResponse
    ]("getApplicationSettings", api.getApplicationSettings)(
      request.buildAwsValue()
    ).map(zio.aws.pinpoint.model.GetApplicationSettingsResponse.wrap)
      .provideEnvironment(r)
    def getSegmentVersion(
        request: zio.aws.pinpoint.model.GetSegmentVersionRequest
    ): IO[AwsError, zio.aws.pinpoint.model.GetSegmentVersionResponse.ReadOnly] =
      asyncRequestResponse[GetSegmentVersionRequest, GetSegmentVersionResponse](
        "getSegmentVersion",
        api.getSegmentVersion
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.GetSegmentVersionResponse.wrap)
        .provideEnvironment(r)
    def deleteCampaign(
        request: zio.aws.pinpoint.model.DeleteCampaignRequest
    ): IO[AwsError, zio.aws.pinpoint.model.DeleteCampaignResponse.ReadOnly] =
      asyncRequestResponse[DeleteCampaignRequest, DeleteCampaignResponse](
        "deleteCampaign",
        api.deleteCampaign
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.DeleteCampaignResponse.wrap)
        .provideEnvironment(r)
    def getCampaign(
        request: zio.aws.pinpoint.model.GetCampaignRequest
    ): IO[AwsError, zio.aws.pinpoint.model.GetCampaignResponse.ReadOnly] =
      asyncRequestResponse[GetCampaignRequest, GetCampaignResponse](
        "getCampaign",
        api.getCampaign
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.GetCampaignResponse.wrap)
        .provideEnvironment(r)
    def getUserEndpoints(
        request: zio.aws.pinpoint.model.GetUserEndpointsRequest
    ): IO[AwsError, zio.aws.pinpoint.model.GetUserEndpointsResponse.ReadOnly] =
      asyncRequestResponse[GetUserEndpointsRequest, GetUserEndpointsResponse](
        "getUserEndpoints",
        api.getUserEndpoints
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.GetUserEndpointsResponse.wrap)
        .provideEnvironment(r)
    def getApp(
        request: zio.aws.pinpoint.model.GetAppRequest
    ): IO[AwsError, zio.aws.pinpoint.model.GetAppResponse.ReadOnly] =
      asyncRequestResponse[GetAppRequest, GetAppResponse]("getApp", api.getApp)(
        request.buildAwsValue()
      ).map(zio.aws.pinpoint.model.GetAppResponse.wrap).provideEnvironment(r)
    def getCampaignDateRangeKpi(
        request: zio.aws.pinpoint.model.GetCampaignDateRangeKpiRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.GetCampaignDateRangeKpiResponse.ReadOnly
    ] = asyncRequestResponse[
      GetCampaignDateRangeKpiRequest,
      GetCampaignDateRangeKpiResponse
    ]("getCampaignDateRangeKpi", api.getCampaignDateRangeKpi)(
      request.buildAwsValue()
    ).map(zio.aws.pinpoint.model.GetCampaignDateRangeKpiResponse.wrap)
      .provideEnvironment(r)
    def deleteApnsSandboxChannel(
        request: zio.aws.pinpoint.model.DeleteApnsSandboxChannelRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.DeleteApnsSandboxChannelResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteApnsSandboxChannelRequest,
      DeleteApnsSandboxChannelResponse
    ]("deleteApnsSandboxChannel", api.deleteApnsSandboxChannel)(
      request.buildAwsValue()
    ).map(zio.aws.pinpoint.model.DeleteApnsSandboxChannelResponse.wrap)
      .provideEnvironment(r)
    def getAdmChannel(
        request: zio.aws.pinpoint.model.GetAdmChannelRequest
    ): IO[AwsError, zio.aws.pinpoint.model.GetAdmChannelResponse.ReadOnly] =
      asyncRequestResponse[GetAdmChannelRequest, GetAdmChannelResponse](
        "getAdmChannel",
        api.getAdmChannel
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.GetAdmChannelResponse.wrap)
        .provideEnvironment(r)
    def getJourneyExecutionActivityMetrics(
        request: zio.aws.pinpoint.model.GetJourneyExecutionActivityMetricsRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.GetJourneyExecutionActivityMetricsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetJourneyExecutionActivityMetricsRequest,
      GetJourneyExecutionActivityMetricsResponse
    ](
      "getJourneyExecutionActivityMetrics",
      api.getJourneyExecutionActivityMetrics
    )(request.buildAwsValue())
      .map(
        zio.aws.pinpoint.model.GetJourneyExecutionActivityMetricsResponse.wrap
      )
      .provideEnvironment(r)
    def updateApnsSandboxChannel(
        request: zio.aws.pinpoint.model.UpdateApnsSandboxChannelRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.UpdateApnsSandboxChannelResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateApnsSandboxChannelRequest,
      UpdateApnsSandboxChannelResponse
    ]("updateApnsSandboxChannel", api.updateApnsSandboxChannel)(
      request.buildAwsValue()
    ).map(zio.aws.pinpoint.model.UpdateApnsSandboxChannelResponse.wrap)
      .provideEnvironment(r)
    def getApnsChannel(
        request: zio.aws.pinpoint.model.GetApnsChannelRequest
    ): IO[AwsError, zio.aws.pinpoint.model.GetApnsChannelResponse.ReadOnly] =
      asyncRequestResponse[GetApnsChannelRequest, GetApnsChannelResponse](
        "getApnsChannel",
        api.getApnsChannel
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.GetApnsChannelResponse.wrap)
        .provideEnvironment(r)
    def getEmailTemplate(
        request: zio.aws.pinpoint.model.GetEmailTemplateRequest
    ): IO[AwsError, zio.aws.pinpoint.model.GetEmailTemplateResponse.ReadOnly] =
      asyncRequestResponse[GetEmailTemplateRequest, GetEmailTemplateResponse](
        "getEmailTemplate",
        api.getEmailTemplate
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.GetEmailTemplateResponse.wrap)
        .provideEnvironment(r)
    def listJourneys(
        request: zio.aws.pinpoint.model.ListJourneysRequest
    ): IO[AwsError, zio.aws.pinpoint.model.ListJourneysResponse.ReadOnly] =
      asyncRequestResponse[ListJourneysRequest, ListJourneysResponse](
        "listJourneys",
        api.listJourneys
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.ListJourneysResponse.wrap)
        .provideEnvironment(r)
    def sendOTPMessage(
        request: zio.aws.pinpoint.model.SendOtpMessageRequest
    ): IO[AwsError, zio.aws.pinpoint.model.SendOtpMessageResponse.ReadOnly] =
      asyncRequestResponse[SendOtpMessageRequest, SendOtpMessageResponse](
        "sendOTPMessage",
        api.sendOTPMessage
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.SendOtpMessageResponse.wrap)
        .provideEnvironment(r)
    def createEmailTemplate(
        request: zio.aws.pinpoint.model.CreateEmailTemplateRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.CreateEmailTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateEmailTemplateRequest,
      CreateEmailTemplateResponse
    ]("createEmailTemplate", api.createEmailTemplate)(request.buildAwsValue())
      .map(zio.aws.pinpoint.model.CreateEmailTemplateResponse.wrap)
      .provideEnvironment(r)
    def removeAttributes(
        request: zio.aws.pinpoint.model.RemoveAttributesRequest
    ): IO[AwsError, zio.aws.pinpoint.model.RemoveAttributesResponse.ReadOnly] =
      asyncRequestResponse[RemoveAttributesRequest, RemoveAttributesResponse](
        "removeAttributes",
        api.removeAttributes
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.RemoveAttributesResponse.wrap)
        .provideEnvironment(r)
    def createPushTemplate(
        request: zio.aws.pinpoint.model.CreatePushTemplateRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.CreatePushTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      CreatePushTemplateRequest,
      CreatePushTemplateResponse
    ]("createPushTemplate", api.createPushTemplate)(request.buildAwsValue())
      .map(zio.aws.pinpoint.model.CreatePushTemplateResponse.wrap)
      .provideEnvironment(r)
    def getCampaignVersion(
        request: zio.aws.pinpoint.model.GetCampaignVersionRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.GetCampaignVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      GetCampaignVersionRequest,
      GetCampaignVersionResponse
    ]("getCampaignVersion", api.getCampaignVersion)(request.buildAwsValue())
      .map(zio.aws.pinpoint.model.GetCampaignVersionResponse.wrap)
      .provideEnvironment(r)
    def updateSegment(
        request: zio.aws.pinpoint.model.UpdateSegmentRequest
    ): IO[AwsError, zio.aws.pinpoint.model.UpdateSegmentResponse.ReadOnly] =
      asyncRequestResponse[UpdateSegmentRequest, UpdateSegmentResponse](
        "updateSegment",
        api.updateSegment
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.UpdateSegmentResponse.wrap)
        .provideEnvironment(r)
    def getCampaignVersions(
        request: zio.aws.pinpoint.model.GetCampaignVersionsRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.GetCampaignVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetCampaignVersionsRequest,
      GetCampaignVersionsResponse
    ]("getCampaignVersions", api.getCampaignVersions)(request.buildAwsValue())
      .map(zio.aws.pinpoint.model.GetCampaignVersionsResponse.wrap)
      .provideEnvironment(r)
    def updateBaiduChannel(
        request: zio.aws.pinpoint.model.UpdateBaiduChannelRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.UpdateBaiduChannelResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateBaiduChannelRequest,
      UpdateBaiduChannelResponse
    ]("updateBaiduChannel", api.updateBaiduChannel)(request.buildAwsValue())
      .map(zio.aws.pinpoint.model.UpdateBaiduChannelResponse.wrap)
      .provideEnvironment(r)
    def createSmsTemplate(
        request: zio.aws.pinpoint.model.CreateSmsTemplateRequest
    ): IO[AwsError, zio.aws.pinpoint.model.CreateSmsTemplateResponse.ReadOnly] =
      asyncRequestResponse[CreateSmsTemplateRequest, CreateSmsTemplateResponse](
        "createSmsTemplate",
        api.createSmsTemplate
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.CreateSmsTemplateResponse.wrap)
        .provideEnvironment(r)
    def createJourney(
        request: zio.aws.pinpoint.model.CreateJourneyRequest
    ): IO[AwsError, zio.aws.pinpoint.model.CreateJourneyResponse.ReadOnly] =
      asyncRequestResponse[CreateJourneyRequest, CreateJourneyResponse](
        "createJourney",
        api.createJourney
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.CreateJourneyResponse.wrap)
        .provideEnvironment(r)
    def getImportJobs(
        request: zio.aws.pinpoint.model.GetImportJobsRequest
    ): IO[AwsError, zio.aws.pinpoint.model.GetImportJobsResponse.ReadOnly] =
      asyncRequestResponse[GetImportJobsRequest, GetImportJobsResponse](
        "getImportJobs",
        api.getImportJobs
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.GetImportJobsResponse.wrap)
        .provideEnvironment(r)
    def getExportJob(
        request: zio.aws.pinpoint.model.GetExportJobRequest
    ): IO[AwsError, zio.aws.pinpoint.model.GetExportJobResponse.ReadOnly] =
      asyncRequestResponse[GetExportJobRequest, GetExportJobResponse](
        "getExportJob",
        api.getExportJob
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.GetExportJobResponse.wrap)
        .provideEnvironment(r)
    def getJourneyRunExecutionMetrics(
        request: zio.aws.pinpoint.model.GetJourneyRunExecutionMetricsRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.GetJourneyRunExecutionMetricsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetJourneyRunExecutionMetricsRequest,
      GetJourneyRunExecutionMetricsResponse
    ]("getJourneyRunExecutionMetrics", api.getJourneyRunExecutionMetrics)(
      request.buildAwsValue()
    ).map(zio.aws.pinpoint.model.GetJourneyRunExecutionMetricsResponse.wrap)
      .provideEnvironment(r)
    def getCampaigns(
        request: zio.aws.pinpoint.model.GetCampaignsRequest
    ): IO[AwsError, zio.aws.pinpoint.model.GetCampaignsResponse.ReadOnly] =
      asyncRequestResponse[GetCampaignsRequest, GetCampaignsResponse](
        "getCampaigns",
        api.getCampaigns
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.GetCampaignsResponse.wrap)
        .provideEnvironment(r)
    def updateApplicationSettings(
        request: zio.aws.pinpoint.model.UpdateApplicationSettingsRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.UpdateApplicationSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateApplicationSettingsRequest,
      UpdateApplicationSettingsResponse
    ]("updateApplicationSettings", api.updateApplicationSettings)(
      request.buildAwsValue()
    ).map(zio.aws.pinpoint.model.UpdateApplicationSettingsResponse.wrap)
      .provideEnvironment(r)
    def getVoiceChannel(
        request: zio.aws.pinpoint.model.GetVoiceChannelRequest
    ): IO[AwsError, zio.aws.pinpoint.model.GetVoiceChannelResponse.ReadOnly] =
      asyncRequestResponse[GetVoiceChannelRequest, GetVoiceChannelResponse](
        "getVoiceChannel",
        api.getVoiceChannel
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.GetVoiceChannelResponse.wrap)
        .provideEnvironment(r)
    def getSmsTemplate(
        request: zio.aws.pinpoint.model.GetSmsTemplateRequest
    ): IO[AwsError, zio.aws.pinpoint.model.GetSmsTemplateResponse.ReadOnly] =
      asyncRequestResponse[GetSmsTemplateRequest, GetSmsTemplateResponse](
        "getSmsTemplate",
        api.getSmsTemplate
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.GetSmsTemplateResponse.wrap)
        .provideEnvironment(r)
    def updateEmailChannel(
        request: zio.aws.pinpoint.model.UpdateEmailChannelRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.UpdateEmailChannelResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateEmailChannelRequest,
      UpdateEmailChannelResponse
    ]("updateEmailChannel", api.updateEmailChannel)(request.buildAwsValue())
      .map(zio.aws.pinpoint.model.UpdateEmailChannelResponse.wrap)
      .provideEnvironment(r)
    def getSegmentImportJobs(
        request: zio.aws.pinpoint.model.GetSegmentImportJobsRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.GetSegmentImportJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetSegmentImportJobsRequest,
      GetSegmentImportJobsResponse
    ]("getSegmentImportJobs", api.getSegmentImportJobs)(request.buildAwsValue())
      .map(zio.aws.pinpoint.model.GetSegmentImportJobsResponse.wrap)
      .provideEnvironment(r)
    def phoneNumberValidate(
        request: zio.aws.pinpoint.model.PhoneNumberValidateRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.PhoneNumberValidateResponse.ReadOnly
    ] = asyncRequestResponse[
      PhoneNumberValidateRequest,
      PhoneNumberValidateResponse
    ]("phoneNumberValidate", api.phoneNumberValidate)(request.buildAwsValue())
      .map(zio.aws.pinpoint.model.PhoneNumberValidateResponse.wrap)
      .provideEnvironment(r)
    def deleteEventStream(
        request: zio.aws.pinpoint.model.DeleteEventStreamRequest
    ): IO[AwsError, zio.aws.pinpoint.model.DeleteEventStreamResponse.ReadOnly] =
      asyncRequestResponse[DeleteEventStreamRequest, DeleteEventStreamResponse](
        "deleteEventStream",
        api.deleteEventStream
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.DeleteEventStreamResponse.wrap)
        .provideEnvironment(r)
    def deleteAdmChannel(
        request: zio.aws.pinpoint.model.DeleteAdmChannelRequest
    ): IO[AwsError, zio.aws.pinpoint.model.DeleteAdmChannelResponse.ReadOnly] =
      asyncRequestResponse[DeleteAdmChannelRequest, DeleteAdmChannelResponse](
        "deleteAdmChannel",
        api.deleteAdmChannel
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.DeleteAdmChannelResponse.wrap)
        .provideEnvironment(r)
    def getJourneyRunExecutionActivityMetrics(
        request: zio.aws.pinpoint.model.GetJourneyRunExecutionActivityMetricsRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.GetJourneyRunExecutionActivityMetricsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetJourneyRunExecutionActivityMetricsRequest,
      GetJourneyRunExecutionActivityMetricsResponse
    ](
      "getJourneyRunExecutionActivityMetrics",
      api.getJourneyRunExecutionActivityMetrics
    )(request.buildAwsValue())
      .map(
        zio.aws.pinpoint.model.GetJourneyRunExecutionActivityMetricsResponse.wrap
      )
      .provideEnvironment(r)
    def updateInAppTemplate(
        request: zio.aws.pinpoint.model.UpdateInAppTemplateRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.UpdateInAppTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateInAppTemplateRequest,
      UpdateInAppTemplateResponse
    ]("updateInAppTemplate", api.updateInAppTemplate)(request.buildAwsValue())
      .map(zio.aws.pinpoint.model.UpdateInAppTemplateResponse.wrap)
      .provideEnvironment(r)
    def getChannels(
        request: zio.aws.pinpoint.model.GetChannelsRequest
    ): IO[AwsError, zio.aws.pinpoint.model.GetChannelsResponse.ReadOnly] =
      asyncRequestResponse[GetChannelsRequest, GetChannelsResponse](
        "getChannels",
        api.getChannels
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.GetChannelsResponse.wrap)
        .provideEnvironment(r)
    def updateApnsChannel(
        request: zio.aws.pinpoint.model.UpdateApnsChannelRequest
    ): IO[AwsError, zio.aws.pinpoint.model.UpdateApnsChannelResponse.ReadOnly] =
      asyncRequestResponse[UpdateApnsChannelRequest, UpdateApnsChannelResponse](
        "updateApnsChannel",
        api.updateApnsChannel
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.UpdateApnsChannelResponse.wrap)
        .provideEnvironment(r)
    def getGcmChannel(
        request: zio.aws.pinpoint.model.GetGcmChannelRequest
    ): IO[AwsError, zio.aws.pinpoint.model.GetGcmChannelResponse.ReadOnly] =
      asyncRequestResponse[GetGcmChannelRequest, GetGcmChannelResponse](
        "getGcmChannel",
        api.getGcmChannel
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.GetGcmChannelResponse.wrap)
        .provideEnvironment(r)
    def deleteJourney(
        request: zio.aws.pinpoint.model.DeleteJourneyRequest
    ): IO[AwsError, zio.aws.pinpoint.model.DeleteJourneyResponse.ReadOnly] =
      asyncRequestResponse[DeleteJourneyRequest, DeleteJourneyResponse](
        "deleteJourney",
        api.deleteJourney
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.DeleteJourneyResponse.wrap)
        .provideEnvironment(r)
    def getApnsVoipSandboxChannel(
        request: zio.aws.pinpoint.model.GetApnsVoipSandboxChannelRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.GetApnsVoipSandboxChannelResponse.ReadOnly
    ] = asyncRequestResponse[
      GetApnsVoipSandboxChannelRequest,
      GetApnsVoipSandboxChannelResponse
    ]("getApnsVoipSandboxChannel", api.getApnsVoipSandboxChannel)(
      request.buildAwsValue()
    ).map(zio.aws.pinpoint.model.GetApnsVoipSandboxChannelResponse.wrap)
      .provideEnvironment(r)
    def putEvents(
        request: zio.aws.pinpoint.model.PutEventsRequest
    ): IO[AwsError, zio.aws.pinpoint.model.PutEventsResponse.ReadOnly] =
      asyncRequestResponse[PutEventsRequest, PutEventsResponse](
        "putEvents",
        api.putEvents
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.PutEventsResponse.wrap)
        .provideEnvironment(r)
    def deleteSmsChannel(
        request: zio.aws.pinpoint.model.DeleteSmsChannelRequest
    ): IO[AwsError, zio.aws.pinpoint.model.DeleteSmsChannelResponse.ReadOnly] =
      asyncRequestResponse[DeleteSmsChannelRequest, DeleteSmsChannelResponse](
        "deleteSmsChannel",
        api.deleteSmsChannel
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.DeleteSmsChannelResponse.wrap)
        .provideEnvironment(r)
    def createApp(
        request: zio.aws.pinpoint.model.CreateAppRequest
    ): IO[AwsError, zio.aws.pinpoint.model.CreateAppResponse.ReadOnly] =
      asyncRequestResponse[CreateAppRequest, CreateAppResponse](
        "createApp",
        api.createApp
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.CreateAppResponse.wrap)
        .provideEnvironment(r)
    def updateRecommenderConfiguration(
        request: zio.aws.pinpoint.model.UpdateRecommenderConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.UpdateRecommenderConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateRecommenderConfigurationRequest,
      UpdateRecommenderConfigurationResponse
    ]("updateRecommenderConfiguration", api.updateRecommenderConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.pinpoint.model.UpdateRecommenderConfigurationResponse.wrap)
      .provideEnvironment(r)
    def updateGcmChannel(
        request: zio.aws.pinpoint.model.UpdateGcmChannelRequest
    ): IO[AwsError, zio.aws.pinpoint.model.UpdateGcmChannelResponse.ReadOnly] =
      asyncRequestResponse[UpdateGcmChannelRequest, UpdateGcmChannelResponse](
        "updateGcmChannel",
        api.updateGcmChannel
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.UpdateGcmChannelResponse.wrap)
        .provideEnvironment(r)
    def deleteEndpoint(
        request: zio.aws.pinpoint.model.DeleteEndpointRequest
    ): IO[AwsError, zio.aws.pinpoint.model.DeleteEndpointResponse.ReadOnly] =
      asyncRequestResponse[DeleteEndpointRequest, DeleteEndpointResponse](
        "deleteEndpoint",
        api.deleteEndpoint
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.DeleteEndpointResponse.wrap)
        .provideEnvironment(r)
    def listTemplates(
        request: zio.aws.pinpoint.model.ListTemplatesRequest
    ): IO[AwsError, zio.aws.pinpoint.model.ListTemplatesResponse.ReadOnly] =
      asyncRequestResponse[ListTemplatesRequest, ListTemplatesResponse](
        "listTemplates",
        api.listTemplates
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.ListTemplatesResponse.wrap)
        .provideEnvironment(r)
    def updatePushTemplate(
        request: zio.aws.pinpoint.model.UpdatePushTemplateRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.UpdatePushTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdatePushTemplateRequest,
      UpdatePushTemplateResponse
    ]("updatePushTemplate", api.updatePushTemplate)(request.buildAwsValue())
      .map(zio.aws.pinpoint.model.UpdatePushTemplateResponse.wrap)
      .provideEnvironment(r)
    def updateVoiceChannel(
        request: zio.aws.pinpoint.model.UpdateVoiceChannelRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.UpdateVoiceChannelResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateVoiceChannelRequest,
      UpdateVoiceChannelResponse
    ]("updateVoiceChannel", api.updateVoiceChannel)(request.buildAwsValue())
      .map(zio.aws.pinpoint.model.UpdateVoiceChannelResponse.wrap)
      .provideEnvironment(r)
    def listTemplateVersions(
        request: zio.aws.pinpoint.model.ListTemplateVersionsRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.ListTemplateVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTemplateVersionsRequest,
      ListTemplateVersionsResponse
    ]("listTemplateVersions", api.listTemplateVersions)(request.buildAwsValue())
      .map(zio.aws.pinpoint.model.ListTemplateVersionsResponse.wrap)
      .provideEnvironment(r)
    def updateJourney(
        request: zio.aws.pinpoint.model.UpdateJourneyRequest
    ): IO[AwsError, zio.aws.pinpoint.model.UpdateJourneyResponse.ReadOnly] =
      asyncRequestResponse[UpdateJourneyRequest, UpdateJourneyResponse](
        "updateJourney",
        api.updateJourney
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.UpdateJourneyResponse.wrap)
        .provideEnvironment(r)
    def deleteSmsTemplate(
        request: zio.aws.pinpoint.model.DeleteSmsTemplateRequest
    ): IO[AwsError, zio.aws.pinpoint.model.DeleteSmsTemplateResponse.ReadOnly] =
      asyncRequestResponse[DeleteSmsTemplateRequest, DeleteSmsTemplateResponse](
        "deleteSmsTemplate",
        api.deleteSmsTemplate
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.DeleteSmsTemplateResponse.wrap)
        .provideEnvironment(r)
    def createInAppTemplate(
        request: zio.aws.pinpoint.model.CreateInAppTemplateRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.CreateInAppTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateInAppTemplateRequest,
      CreateInAppTemplateResponse
    ]("createInAppTemplate", api.createInAppTemplate)(request.buildAwsValue())
      .map(zio.aws.pinpoint.model.CreateInAppTemplateResponse.wrap)
      .provideEnvironment(r)
    def getInAppTemplate(
        request: zio.aws.pinpoint.model.GetInAppTemplateRequest
    ): IO[AwsError, zio.aws.pinpoint.model.GetInAppTemplateResponse.ReadOnly] =
      asyncRequestResponse[GetInAppTemplateRequest, GetInAppTemplateResponse](
        "getInAppTemplate",
        api.getInAppTemplate
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.GetInAppTemplateResponse.wrap)
        .provideEnvironment(r)
    def getSegmentExportJobs(
        request: zio.aws.pinpoint.model.GetSegmentExportJobsRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.GetSegmentExportJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetSegmentExportJobsRequest,
      GetSegmentExportJobsResponse
    ]("getSegmentExportJobs", api.getSegmentExportJobs)(request.buildAwsValue())
      .map(zio.aws.pinpoint.model.GetSegmentExportJobsResponse.wrap)
      .provideEnvironment(r)
    def getSegment(
        request: zio.aws.pinpoint.model.GetSegmentRequest
    ): IO[AwsError, zio.aws.pinpoint.model.GetSegmentResponse.ReadOnly] =
      asyncRequestResponse[GetSegmentRequest, GetSegmentResponse](
        "getSegment",
        api.getSegment
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.GetSegmentResponse.wrap)
        .provideEnvironment(r)
    def createImportJob(
        request: zio.aws.pinpoint.model.CreateImportJobRequest
    ): IO[AwsError, zio.aws.pinpoint.model.CreateImportJobResponse.ReadOnly] =
      asyncRequestResponse[CreateImportJobRequest, CreateImportJobResponse](
        "createImportJob",
        api.createImportJob
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.CreateImportJobResponse.wrap)
        .provideEnvironment(r)
    def deleteApp(
        request: zio.aws.pinpoint.model.DeleteAppRequest
    ): IO[AwsError, zio.aws.pinpoint.model.DeleteAppResponse.ReadOnly] =
      asyncRequestResponse[DeleteAppRequest, DeleteAppResponse](
        "deleteApp",
        api.deleteApp
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.DeleteAppResponse.wrap)
        .provideEnvironment(r)
    def createExportJob(
        request: zio.aws.pinpoint.model.CreateExportJobRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[CreateExportJobRequest, CreateExportJobResponse](
        "createExportJob",
        api.createExportJob
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.CreateExportJobResponse.wrap)
        .provideEnvironment(r)
    def updateApnsVoipSandboxChannel(
        request: zio.aws.pinpoint.model.UpdateApnsVoipSandboxChannelRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.UpdateApnsVoipSandboxChannelResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateApnsVoipSandboxChannelRequest,
      UpdateApnsVoipSandboxChannelResponse
    ]("updateApnsVoipSandboxChannel", api.updateApnsVoipSandboxChannel)(
      request.buildAwsValue()
    ).map(zio.aws.pinpoint.model.UpdateApnsVoipSandboxChannelResponse.wrap)
      .provideEnvironment(r)
    def createRecommenderConfiguration(
        request: zio.aws.pinpoint.model.CreateRecommenderConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.CreateRecommenderConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateRecommenderConfigurationRequest,
      CreateRecommenderConfigurationResponse
    ]("createRecommenderConfiguration", api.createRecommenderConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.pinpoint.model.CreateRecommenderConfigurationResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: zio.aws.pinpoint.model.UntagResourceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def updateSmsTemplate(
        request: zio.aws.pinpoint.model.UpdateSmsTemplateRequest
    ): IO[AwsError, zio.aws.pinpoint.model.UpdateSmsTemplateResponse.ReadOnly] =
      asyncRequestResponse[UpdateSmsTemplateRequest, UpdateSmsTemplateResponse](
        "updateSmsTemplate",
        api.updateSmsTemplate
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.UpdateSmsTemplateResponse.wrap)
        .provideEnvironment(r)
    def getCampaignActivities(
        request: zio.aws.pinpoint.model.GetCampaignActivitiesRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.GetCampaignActivitiesResponse.ReadOnly
    ] = asyncRequestResponse[
      GetCampaignActivitiesRequest,
      GetCampaignActivitiesResponse
    ]("getCampaignActivities", api.getCampaignActivities)(
      request.buildAwsValue()
    ).map(zio.aws.pinpoint.model.GetCampaignActivitiesResponse.wrap)
      .provideEnvironment(r)
    def getApnsSandboxChannel(
        request: zio.aws.pinpoint.model.GetApnsSandboxChannelRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.GetApnsSandboxChannelResponse.ReadOnly
    ] = asyncRequestResponse[
      GetApnsSandboxChannelRequest,
      GetApnsSandboxChannelResponse
    ]("getApnsSandboxChannel", api.getApnsSandboxChannel)(
      request.buildAwsValue()
    ).map(zio.aws.pinpoint.model.GetApnsSandboxChannelResponse.wrap)
      .provideEnvironment(r)
    def updateAdmChannel(
        request: zio.aws.pinpoint.model.UpdateAdmChannelRequest
    ): IO[AwsError, zio.aws.pinpoint.model.UpdateAdmChannelResponse.ReadOnly] =
      asyncRequestResponse[UpdateAdmChannelRequest, UpdateAdmChannelResponse](
        "updateAdmChannel",
        api.updateAdmChannel
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.UpdateAdmChannelResponse.wrap)
        .provideEnvironment(r)
    def deleteEmailTemplate(
        request: zio.aws.pinpoint.model.DeleteEmailTemplateRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.DeleteEmailTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteEmailTemplateRequest,
      DeleteEmailTemplateResponse
    ]("deleteEmailTemplate", api.deleteEmailTemplate)(request.buildAwsValue())
      .map(zio.aws.pinpoint.model.DeleteEmailTemplateResponse.wrap)
      .provideEnvironment(r)
    def getVoiceTemplate(
        request: zio.aws.pinpoint.model.GetVoiceTemplateRequest
    ): IO[AwsError, zio.aws.pinpoint.model.GetVoiceTemplateResponse.ReadOnly] =
      asyncRequestResponse[GetVoiceTemplateRequest, GetVoiceTemplateResponse](
        "getVoiceTemplate",
        api.getVoiceTemplate
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.GetVoiceTemplateResponse.wrap)
        .provideEnvironment(r)
    def deleteVoiceChannel(
        request: zio.aws.pinpoint.model.DeleteVoiceChannelRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.DeleteVoiceChannelResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteVoiceChannelRequest,
      DeleteVoiceChannelResponse
    ]("deleteVoiceChannel", api.deleteVoiceChannel)(request.buildAwsValue())
      .map(zio.aws.pinpoint.model.DeleteVoiceChannelResponse.wrap)
      .provideEnvironment(r)
    def getApnsVoipChannel(
        request: zio.aws.pinpoint.model.GetApnsVoipChannelRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.GetApnsVoipChannelResponse.ReadOnly
    ] = asyncRequestResponse[
      GetApnsVoipChannelRequest,
      GetApnsVoipChannelResponse
    ]("getApnsVoipChannel", api.getApnsVoipChannel)(request.buildAwsValue())
      .map(zio.aws.pinpoint.model.GetApnsVoipChannelResponse.wrap)
      .provideEnvironment(r)
    def createSegment(
        request: zio.aws.pinpoint.model.CreateSegmentRequest
    ): IO[AwsError, zio.aws.pinpoint.model.CreateSegmentResponse.ReadOnly] =
      asyncRequestResponse[CreateSegmentRequest, CreateSegmentResponse](
        "createSegment",
        api.createSegment
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.CreateSegmentResponse.wrap)
        .provideEnvironment(r)
    def deleteEmailChannel(
        request: zio.aws.pinpoint.model.DeleteEmailChannelRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.DeleteEmailChannelResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteEmailChannelRequest,
      DeleteEmailChannelResponse
    ]("deleteEmailChannel", api.deleteEmailChannel)(request.buildAwsValue())
      .map(zio.aws.pinpoint.model.DeleteEmailChannelResponse.wrap)
      .provideEnvironment(r)
    def getJourneyExecutionMetrics(
        request: zio.aws.pinpoint.model.GetJourneyExecutionMetricsRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.GetJourneyExecutionMetricsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetJourneyExecutionMetricsRequest,
      GetJourneyExecutionMetricsResponse
    ]("getJourneyExecutionMetrics", api.getJourneyExecutionMetrics)(
      request.buildAwsValue()
    ).map(zio.aws.pinpoint.model.GetJourneyExecutionMetricsResponse.wrap)
      .provideEnvironment(r)
    def updateTemplateActiveVersion(
        request: zio.aws.pinpoint.model.UpdateTemplateActiveVersionRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.UpdateTemplateActiveVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateTemplateActiveVersionRequest,
      UpdateTemplateActiveVersionResponse
    ]("updateTemplateActiveVersion", api.updateTemplateActiveVersion)(
      request.buildAwsValue()
    ).map(zio.aws.pinpoint.model.UpdateTemplateActiveVersionResponse.wrap)
      .provideEnvironment(r)
    def getJourneyDateRangeKpi(
        request: zio.aws.pinpoint.model.GetJourneyDateRangeKpiRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.GetJourneyDateRangeKpiResponse.ReadOnly
    ] = asyncRequestResponse[
      GetJourneyDateRangeKpiRequest,
      GetJourneyDateRangeKpiResponse
    ]("getJourneyDateRangeKpi", api.getJourneyDateRangeKpi)(
      request.buildAwsValue()
    ).map(zio.aws.pinpoint.model.GetJourneyDateRangeKpiResponse.wrap)
      .provideEnvironment(r)
    def getJourney(
        request: zio.aws.pinpoint.model.GetJourneyRequest
    ): IO[AwsError, zio.aws.pinpoint.model.GetJourneyResponse.ReadOnly] =
      asyncRequestResponse[GetJourneyRequest, GetJourneyResponse](
        "getJourney",
        api.getJourney
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.GetJourneyResponse.wrap)
        .provideEnvironment(r)
    def updateVoiceTemplate(
        request: zio.aws.pinpoint.model.UpdateVoiceTemplateRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.UpdateVoiceTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateVoiceTemplateRequest,
      UpdateVoiceTemplateResponse
    ]("updateVoiceTemplate", api.updateVoiceTemplate)(request.buildAwsValue())
      .map(zio.aws.pinpoint.model.UpdateVoiceTemplateResponse.wrap)
      .provideEnvironment(r)
    def deleteApnsVoipSandboxChannel(
        request: zio.aws.pinpoint.model.DeleteApnsVoipSandboxChannelRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.DeleteApnsVoipSandboxChannelResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteApnsVoipSandboxChannelRequest,
      DeleteApnsVoipSandboxChannelResponse
    ]("deleteApnsVoipSandboxChannel", api.deleteApnsVoipSandboxChannel)(
      request.buildAwsValue()
    ).map(zio.aws.pinpoint.model.DeleteApnsVoipSandboxChannelResponse.wrap)
      .provideEnvironment(r)
    def getApplicationDateRangeKpi(
        request: zio.aws.pinpoint.model.GetApplicationDateRangeKpiRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.GetApplicationDateRangeKpiResponse.ReadOnly
    ] = asyncRequestResponse[
      GetApplicationDateRangeKpiRequest,
      GetApplicationDateRangeKpiResponse
    ]("getApplicationDateRangeKpi", api.getApplicationDateRangeKpi)(
      request.buildAwsValue()
    ).map(zio.aws.pinpoint.model.GetApplicationDateRangeKpiResponse.wrap)
      .provideEnvironment(r)
    def createCampaign(
        request: zio.aws.pinpoint.model.CreateCampaignRequest
    ): IO[AwsError, zio.aws.pinpoint.model.CreateCampaignResponse.ReadOnly] =
      asyncRequestResponse[CreateCampaignRequest, CreateCampaignResponse](
        "createCampaign",
        api.createCampaign
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.CreateCampaignResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.pinpoint.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.pinpoint.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def getSegments(
        request: zio.aws.pinpoint.model.GetSegmentsRequest
    ): IO[AwsError, zio.aws.pinpoint.model.GetSegmentsResponse.ReadOnly] =
      asyncRequestResponse[GetSegmentsRequest, GetSegmentsResponse](
        "getSegments",
        api.getSegments
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.GetSegmentsResponse.wrap)
        .provideEnvironment(r)
    def updateEmailTemplate(
        request: zio.aws.pinpoint.model.UpdateEmailTemplateRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.UpdateEmailTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateEmailTemplateRequest,
      UpdateEmailTemplateResponse
    ]("updateEmailTemplate", api.updateEmailTemplate)(request.buildAwsValue())
      .map(zio.aws.pinpoint.model.UpdateEmailTemplateResponse.wrap)
      .provideEnvironment(r)
    def getExportJobs(
        request: zio.aws.pinpoint.model.GetExportJobsRequest
    ): IO[AwsError, zio.aws.pinpoint.model.GetExportJobsResponse.ReadOnly] =
      asyncRequestResponse[GetExportJobsRequest, GetExportJobsResponse](
        "getExportJobs",
        api.getExportJobs
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.GetExportJobsResponse.wrap)
        .provideEnvironment(r)
    def updateJourneyState(
        request: zio.aws.pinpoint.model.UpdateJourneyStateRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.UpdateJourneyStateResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateJourneyStateRequest,
      UpdateJourneyStateResponse
    ]("updateJourneyState", api.updateJourneyState)(request.buildAwsValue())
      .map(zio.aws.pinpoint.model.UpdateJourneyStateResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.pinpoint.model.TagResourceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getSmsChannel(
        request: zio.aws.pinpoint.model.GetSmsChannelRequest
    ): IO[AwsError, zio.aws.pinpoint.model.GetSmsChannelResponse.ReadOnly] =
      asyncRequestResponse[GetSmsChannelRequest, GetSmsChannelResponse](
        "getSmsChannel",
        api.getSmsChannel
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.GetSmsChannelResponse.wrap)
        .provideEnvironment(r)
    def deleteInAppTemplate(
        request: zio.aws.pinpoint.model.DeleteInAppTemplateRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.DeleteInAppTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteInAppTemplateRequest,
      DeleteInAppTemplateResponse
    ]("deleteInAppTemplate", api.deleteInAppTemplate)(request.buildAwsValue())
      .map(zio.aws.pinpoint.model.DeleteInAppTemplateResponse.wrap)
      .provideEnvironment(r)
    def deleteRecommenderConfiguration(
        request: zio.aws.pinpoint.model.DeleteRecommenderConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.DeleteRecommenderConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteRecommenderConfigurationRequest,
      DeleteRecommenderConfigurationResponse
    ]("deleteRecommenderConfiguration", api.deleteRecommenderConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.pinpoint.model.DeleteRecommenderConfigurationResponse.wrap)
      .provideEnvironment(r)
    def updateEndpoint(
        request: zio.aws.pinpoint.model.UpdateEndpointRequest
    ): IO[AwsError, zio.aws.pinpoint.model.UpdateEndpointResponse.ReadOnly] =
      asyncRequestResponse[UpdateEndpointRequest, UpdateEndpointResponse](
        "updateEndpoint",
        api.updateEndpoint
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.UpdateEndpointResponse.wrap)
        .provideEnvironment(r)
    def deleteApnsChannel(
        request: zio.aws.pinpoint.model.DeleteApnsChannelRequest
    ): IO[AwsError, zio.aws.pinpoint.model.DeleteApnsChannelResponse.ReadOnly] =
      asyncRequestResponse[DeleteApnsChannelRequest, DeleteApnsChannelResponse](
        "deleteApnsChannel",
        api.deleteApnsChannel
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.DeleteApnsChannelResponse.wrap)
        .provideEnvironment(r)
    def deleteApnsVoipChannel(
        request: zio.aws.pinpoint.model.DeleteApnsVoipChannelRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.DeleteApnsVoipChannelResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteApnsVoipChannelRequest,
      DeleteApnsVoipChannelResponse
    ]("deleteApnsVoipChannel", api.deleteApnsVoipChannel)(
      request.buildAwsValue()
    ).map(zio.aws.pinpoint.model.DeleteApnsVoipChannelResponse.wrap)
      .provideEnvironment(r)
    def deletePushTemplate(
        request: zio.aws.pinpoint.model.DeletePushTemplateRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.DeletePushTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      DeletePushTemplateRequest,
      DeletePushTemplateResponse
    ]("deletePushTemplate", api.deletePushTemplate)(request.buildAwsValue())
      .map(zio.aws.pinpoint.model.DeletePushTemplateResponse.wrap)
      .provideEnvironment(r)
    def updateApnsVoipChannel(
        request: zio.aws.pinpoint.model.UpdateApnsVoipChannelRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.UpdateApnsVoipChannelResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateApnsVoipChannelRequest,
      UpdateApnsVoipChannelResponse
    ]("updateApnsVoipChannel", api.updateApnsVoipChannel)(
      request.buildAwsValue()
    ).map(zio.aws.pinpoint.model.UpdateApnsVoipChannelResponse.wrap)
      .provideEnvironment(r)
    def getPushTemplate(
        request: zio.aws.pinpoint.model.GetPushTemplateRequest
    ): IO[AwsError, zio.aws.pinpoint.model.GetPushTemplateResponse.ReadOnly] =
      asyncRequestResponse[GetPushTemplateRequest, GetPushTemplateResponse](
        "getPushTemplate",
        api.getPushTemplate
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.GetPushTemplateResponse.wrap)
        .provideEnvironment(r)
    def getImportJob(
        request: zio.aws.pinpoint.model.GetImportJobRequest
    ): IO[AwsError, zio.aws.pinpoint.model.GetImportJobResponse.ReadOnly] =
      asyncRequestResponse[GetImportJobRequest, GetImportJobResponse](
        "getImportJob",
        api.getImportJob
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.GetImportJobResponse.wrap)
        .provideEnvironment(r)
    def getRecommenderConfiguration(
        request: zio.aws.pinpoint.model.GetRecommenderConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.GetRecommenderConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetRecommenderConfigurationRequest,
      GetRecommenderConfigurationResponse
    ]("getRecommenderConfiguration", api.getRecommenderConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.pinpoint.model.GetRecommenderConfigurationResponse.wrap)
      .provideEnvironment(r)
    def sendUsersMessages(
        request: zio.aws.pinpoint.model.SendUsersMessagesRequest
    ): IO[AwsError, zio.aws.pinpoint.model.SendUsersMessagesResponse.ReadOnly] =
      asyncRequestResponse[SendUsersMessagesRequest, SendUsersMessagesResponse](
        "sendUsersMessages",
        api.sendUsersMessages
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.SendUsersMessagesResponse.wrap)
        .provideEnvironment(r)
    def deleteUserEndpoints(
        request: zio.aws.pinpoint.model.DeleteUserEndpointsRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.DeleteUserEndpointsResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteUserEndpointsRequest,
      DeleteUserEndpointsResponse
    ]("deleteUserEndpoints", api.deleteUserEndpoints)(request.buildAwsValue())
      .map(zio.aws.pinpoint.model.DeleteUserEndpointsResponse.wrap)
      .provideEnvironment(r)
    def updateSmsChannel(
        request: zio.aws.pinpoint.model.UpdateSmsChannelRequest
    ): IO[AwsError, zio.aws.pinpoint.model.UpdateSmsChannelResponse.ReadOnly] =
      asyncRequestResponse[UpdateSmsChannelRequest, UpdateSmsChannelResponse](
        "updateSmsChannel",
        api.updateSmsChannel
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.UpdateSmsChannelResponse.wrap)
        .provideEnvironment(r)
    def getSegmentVersions(
        request: zio.aws.pinpoint.model.GetSegmentVersionsRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.GetSegmentVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetSegmentVersionsRequest,
      GetSegmentVersionsResponse
    ]("getSegmentVersions", api.getSegmentVersions)(request.buildAwsValue())
      .map(zio.aws.pinpoint.model.GetSegmentVersionsResponse.wrap)
      .provideEnvironment(r)
    def createVoiceTemplate(
        request: zio.aws.pinpoint.model.CreateVoiceTemplateRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.CreateVoiceTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateVoiceTemplateRequest,
      CreateVoiceTemplateResponse
    ]("createVoiceTemplate", api.createVoiceTemplate)(request.buildAwsValue())
      .map(zio.aws.pinpoint.model.CreateVoiceTemplateResponse.wrap)
      .provideEnvironment(r)
    def putEventStream(
        request: zio.aws.pinpoint.model.PutEventStreamRequest
    ): IO[AwsError, zio.aws.pinpoint.model.PutEventStreamResponse.ReadOnly] =
      asyncRequestResponse[PutEventStreamRequest, PutEventStreamResponse](
        "putEventStream",
        api.putEventStream
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.PutEventStreamResponse.wrap)
        .provideEnvironment(r)
    def deleteBaiduChannel(
        request: zio.aws.pinpoint.model.DeleteBaiduChannelRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.DeleteBaiduChannelResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteBaiduChannelRequest,
      DeleteBaiduChannelResponse
    ]("deleteBaiduChannel", api.deleteBaiduChannel)(request.buildAwsValue())
      .map(zio.aws.pinpoint.model.DeleteBaiduChannelResponse.wrap)
      .provideEnvironment(r)
    def deleteGcmChannel(
        request: zio.aws.pinpoint.model.DeleteGcmChannelRequest
    ): IO[AwsError, zio.aws.pinpoint.model.DeleteGcmChannelResponse.ReadOnly] =
      asyncRequestResponse[DeleteGcmChannelRequest, DeleteGcmChannelResponse](
        "deleteGcmChannel",
        api.deleteGcmChannel
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.DeleteGcmChannelResponse.wrap)
        .provideEnvironment(r)
    def verifyOTPMessage(
        request: zio.aws.pinpoint.model.VerifyOtpMessageRequest
    ): IO[AwsError, zio.aws.pinpoint.model.VerifyOtpMessageResponse.ReadOnly] =
      asyncRequestResponse[VerifyOtpMessageRequest, VerifyOtpMessageResponse](
        "verifyOTPMessage",
        api.verifyOTPMessage
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.VerifyOtpMessageResponse.wrap)
        .provideEnvironment(r)
    def deleteVoiceTemplate(
        request: zio.aws.pinpoint.model.DeleteVoiceTemplateRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.DeleteVoiceTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteVoiceTemplateRequest,
      DeleteVoiceTemplateResponse
    ]("deleteVoiceTemplate", api.deleteVoiceTemplate)(request.buildAwsValue())
      .map(zio.aws.pinpoint.model.DeleteVoiceTemplateResponse.wrap)
      .provideEnvironment(r)
    def getRecommenderConfigurations(
        request: zio.aws.pinpoint.model.GetRecommenderConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.pinpoint.model.GetRecommenderConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetRecommenderConfigurationsRequest,
      GetRecommenderConfigurationsResponse
    ]("getRecommenderConfigurations", api.getRecommenderConfigurations)(
      request.buildAwsValue()
    ).map(zio.aws.pinpoint.model.GetRecommenderConfigurationsResponse.wrap)
      .provideEnvironment(r)
    def getBaiduChannel(
        request: zio.aws.pinpoint.model.GetBaiduChannelRequest
    ): IO[AwsError, zio.aws.pinpoint.model.GetBaiduChannelResponse.ReadOnly] =
      asyncRequestResponse[GetBaiduChannelRequest, GetBaiduChannelResponse](
        "getBaiduChannel",
        api.getBaiduChannel
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.GetBaiduChannelResponse.wrap)
        .provideEnvironment(r)
    def updateCampaign(
        request: zio.aws.pinpoint.model.UpdateCampaignRequest
    ): IO[AwsError, zio.aws.pinpoint.model.UpdateCampaignResponse.ReadOnly] =
      asyncRequestResponse[UpdateCampaignRequest, UpdateCampaignResponse](
        "updateCampaign",
        api.updateCampaign
      )(request.buildAwsValue())
        .map(zio.aws.pinpoint.model.UpdateCampaignResponse.wrap)
        .provideEnvironment(r)
  }
  def deleteSegment(request: zio.aws.pinpoint.model.DeleteSegmentRequest): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.DeleteSegmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSegment(request))
  def getInAppMessages(
      request: zio.aws.pinpoint.model.GetInAppMessagesRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetInAppMessagesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getInAppMessages(request))
  def getEndpoint(request: zio.aws.pinpoint.model.GetEndpointRequest): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEndpoint(request))
  def getEventStream(
      request: zio.aws.pinpoint.model.GetEventStreamRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetEventStreamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEventStream(request))
  def getEmailChannel(
      request: zio.aws.pinpoint.model.GetEmailChannelRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetEmailChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEmailChannel(request))
  def updateEndpointsBatch(
      request: zio.aws.pinpoint.model.UpdateEndpointsBatchRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.UpdateEndpointsBatchResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateEndpointsBatch(request))
  def getJourneyRuns(
      request: zio.aws.pinpoint.model.GetJourneyRunsRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetJourneyRunsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getJourneyRuns(request))
  def getApps(request: zio.aws.pinpoint.model.GetAppsRequest): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetAppsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getApps(request))
  def sendMessages(request: zio.aws.pinpoint.model.SendMessagesRequest): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.SendMessagesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendMessages(request))
  def getApplicationSettings(
      request: zio.aws.pinpoint.model.GetApplicationSettingsRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetApplicationSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getApplicationSettings(request))
  def getSegmentVersion(
      request: zio.aws.pinpoint.model.GetSegmentVersionRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetSegmentVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSegmentVersion(request))
  def deleteCampaign(
      request: zio.aws.pinpoint.model.DeleteCampaignRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.DeleteCampaignResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCampaign(request))
  def getCampaign(request: zio.aws.pinpoint.model.GetCampaignRequest): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetCampaignResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCampaign(request))
  def getUserEndpoints(
      request: zio.aws.pinpoint.model.GetUserEndpointsRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetUserEndpointsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getUserEndpoints(request))
  def getApp(request: zio.aws.pinpoint.model.GetAppRequest): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetAppResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getApp(request))
  def getCampaignDateRangeKpi(
      request: zio.aws.pinpoint.model.GetCampaignDateRangeKpiRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetCampaignDateRangeKpiResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCampaignDateRangeKpi(request))
  def deleteApnsSandboxChannel(
      request: zio.aws.pinpoint.model.DeleteApnsSandboxChannelRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.DeleteApnsSandboxChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteApnsSandboxChannel(request))
  def getAdmChannel(request: zio.aws.pinpoint.model.GetAdmChannelRequest): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetAdmChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAdmChannel(request))
  def getJourneyExecutionActivityMetrics(
      request: zio.aws.pinpoint.model.GetJourneyExecutionActivityMetricsRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetJourneyExecutionActivityMetricsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getJourneyExecutionActivityMetrics(request))
  def updateApnsSandboxChannel(
      request: zio.aws.pinpoint.model.UpdateApnsSandboxChannelRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.UpdateApnsSandboxChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateApnsSandboxChannel(request))
  def getApnsChannel(
      request: zio.aws.pinpoint.model.GetApnsChannelRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetApnsChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getApnsChannel(request))
  def getEmailTemplate(
      request: zio.aws.pinpoint.model.GetEmailTemplateRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetEmailTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEmailTemplate(request))
  def listJourneys(request: zio.aws.pinpoint.model.ListJourneysRequest): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.ListJourneysResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listJourneys(request))
  def sendOTPMessage(
      request: zio.aws.pinpoint.model.SendOtpMessageRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.SendOtpMessageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendOTPMessage(request))
  def createEmailTemplate(
      request: zio.aws.pinpoint.model.CreateEmailTemplateRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.CreateEmailTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEmailTemplate(request))
  def removeAttributes(
      request: zio.aws.pinpoint.model.RemoveAttributesRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.RemoveAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.removeAttributes(request))
  def createPushTemplate(
      request: zio.aws.pinpoint.model.CreatePushTemplateRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.CreatePushTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPushTemplate(request))
  def getCampaignVersion(
      request: zio.aws.pinpoint.model.GetCampaignVersionRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetCampaignVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCampaignVersion(request))
  def updateSegment(request: zio.aws.pinpoint.model.UpdateSegmentRequest): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.UpdateSegmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSegment(request))
  def getCampaignVersions(
      request: zio.aws.pinpoint.model.GetCampaignVersionsRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetCampaignVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCampaignVersions(request))
  def updateBaiduChannel(
      request: zio.aws.pinpoint.model.UpdateBaiduChannelRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.UpdateBaiduChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateBaiduChannel(request))
  def createSmsTemplate(
      request: zio.aws.pinpoint.model.CreateSmsTemplateRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.CreateSmsTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSmsTemplate(request))
  def createJourney(request: zio.aws.pinpoint.model.CreateJourneyRequest): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.CreateJourneyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createJourney(request))
  def getImportJobs(request: zio.aws.pinpoint.model.GetImportJobsRequest): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetImportJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getImportJobs(request))
  def getExportJob(request: zio.aws.pinpoint.model.GetExportJobRequest): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetExportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getExportJob(request))
  def getJourneyRunExecutionMetrics(
      request: zio.aws.pinpoint.model.GetJourneyRunExecutionMetricsRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetJourneyRunExecutionMetricsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getJourneyRunExecutionMetrics(request))
  def getCampaigns(request: zio.aws.pinpoint.model.GetCampaignsRequest): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetCampaignsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCampaigns(request))
  def updateApplicationSettings(
      request: zio.aws.pinpoint.model.UpdateApplicationSettingsRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.UpdateApplicationSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateApplicationSettings(request))
  def getVoiceChannel(
      request: zio.aws.pinpoint.model.GetVoiceChannelRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetVoiceChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVoiceChannel(request))
  def getSmsTemplate(
      request: zio.aws.pinpoint.model.GetSmsTemplateRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetSmsTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSmsTemplate(request))
  def updateEmailChannel(
      request: zio.aws.pinpoint.model.UpdateEmailChannelRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.UpdateEmailChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateEmailChannel(request))
  def getSegmentImportJobs(
      request: zio.aws.pinpoint.model.GetSegmentImportJobsRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetSegmentImportJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSegmentImportJobs(request))
  def phoneNumberValidate(
      request: zio.aws.pinpoint.model.PhoneNumberValidateRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.PhoneNumberValidateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.phoneNumberValidate(request))
  def deleteEventStream(
      request: zio.aws.pinpoint.model.DeleteEventStreamRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.DeleteEventStreamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEventStream(request))
  def deleteAdmChannel(
      request: zio.aws.pinpoint.model.DeleteAdmChannelRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.DeleteAdmChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAdmChannel(request))
  def getJourneyRunExecutionActivityMetrics(
      request: zio.aws.pinpoint.model.GetJourneyRunExecutionActivityMetricsRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetJourneyRunExecutionActivityMetricsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getJourneyRunExecutionActivityMetrics(request))
  def updateInAppTemplate(
      request: zio.aws.pinpoint.model.UpdateInAppTemplateRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.UpdateInAppTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateInAppTemplate(request))
  def getChannels(request: zio.aws.pinpoint.model.GetChannelsRequest): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetChannelsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getChannels(request))
  def updateApnsChannel(
      request: zio.aws.pinpoint.model.UpdateApnsChannelRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.UpdateApnsChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateApnsChannel(request))
  def getGcmChannel(request: zio.aws.pinpoint.model.GetGcmChannelRequest): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetGcmChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getGcmChannel(request))
  def deleteJourney(request: zio.aws.pinpoint.model.DeleteJourneyRequest): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.DeleteJourneyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteJourney(request))
  def getApnsVoipSandboxChannel(
      request: zio.aws.pinpoint.model.GetApnsVoipSandboxChannelRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetApnsVoipSandboxChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getApnsVoipSandboxChannel(request))
  def putEvents(request: zio.aws.pinpoint.model.PutEventsRequest): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.PutEventsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putEvents(request))
  def deleteSmsChannel(
      request: zio.aws.pinpoint.model.DeleteSmsChannelRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.DeleteSmsChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSmsChannel(request))
  def createApp(request: zio.aws.pinpoint.model.CreateAppRequest): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.CreateAppResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createApp(request))
  def updateRecommenderConfiguration(
      request: zio.aws.pinpoint.model.UpdateRecommenderConfigurationRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.UpdateRecommenderConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRecommenderConfiguration(request))
  def updateGcmChannel(
      request: zio.aws.pinpoint.model.UpdateGcmChannelRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.UpdateGcmChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateGcmChannel(request))
  def deleteEndpoint(
      request: zio.aws.pinpoint.model.DeleteEndpointRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.DeleteEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEndpoint(request))
  def listTemplates(request: zio.aws.pinpoint.model.ListTemplatesRequest): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.ListTemplatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTemplates(request))
  def updatePushTemplate(
      request: zio.aws.pinpoint.model.UpdatePushTemplateRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.UpdatePushTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updatePushTemplate(request))
  def updateVoiceChannel(
      request: zio.aws.pinpoint.model.UpdateVoiceChannelRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.UpdateVoiceChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateVoiceChannel(request))
  def listTemplateVersions(
      request: zio.aws.pinpoint.model.ListTemplateVersionsRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.ListTemplateVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTemplateVersions(request))
  def updateJourney(request: zio.aws.pinpoint.model.UpdateJourneyRequest): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.UpdateJourneyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateJourney(request))
  def deleteSmsTemplate(
      request: zio.aws.pinpoint.model.DeleteSmsTemplateRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.DeleteSmsTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSmsTemplate(request))
  def createInAppTemplate(
      request: zio.aws.pinpoint.model.CreateInAppTemplateRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.CreateInAppTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createInAppTemplate(request))
  def getInAppTemplate(
      request: zio.aws.pinpoint.model.GetInAppTemplateRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetInAppTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getInAppTemplate(request))
  def getSegmentExportJobs(
      request: zio.aws.pinpoint.model.GetSegmentExportJobsRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetSegmentExportJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSegmentExportJobs(request))
  def getSegment(request: zio.aws.pinpoint.model.GetSegmentRequest): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetSegmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSegment(request))
  def createImportJob(
      request: zio.aws.pinpoint.model.CreateImportJobRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.CreateImportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createImportJob(request))
  def deleteApp(request: zio.aws.pinpoint.model.DeleteAppRequest): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.DeleteAppResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteApp(request))
  def createExportJob(
      request: zio.aws.pinpoint.model.CreateExportJobRequest
  ): ZIO[zio.aws.pinpoint.Pinpoint, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.createExportJob(request))
  def updateApnsVoipSandboxChannel(
      request: zio.aws.pinpoint.model.UpdateApnsVoipSandboxChannelRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.UpdateApnsVoipSandboxChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateApnsVoipSandboxChannel(request))
  def createRecommenderConfiguration(
      request: zio.aws.pinpoint.model.CreateRecommenderConfigurationRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.CreateRecommenderConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRecommenderConfiguration(request))
  def untagResource(
      request: zio.aws.pinpoint.model.UntagResourceRequest
  ): ZIO[zio.aws.pinpoint.Pinpoint, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagResource(request))
  def updateSmsTemplate(
      request: zio.aws.pinpoint.model.UpdateSmsTemplateRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.UpdateSmsTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSmsTemplate(request))
  def getCampaignActivities(
      request: zio.aws.pinpoint.model.GetCampaignActivitiesRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetCampaignActivitiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCampaignActivities(request))
  def getApnsSandboxChannel(
      request: zio.aws.pinpoint.model.GetApnsSandboxChannelRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetApnsSandboxChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getApnsSandboxChannel(request))
  def updateAdmChannel(
      request: zio.aws.pinpoint.model.UpdateAdmChannelRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.UpdateAdmChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAdmChannel(request))
  def deleteEmailTemplate(
      request: zio.aws.pinpoint.model.DeleteEmailTemplateRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.DeleteEmailTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEmailTemplate(request))
  def getVoiceTemplate(
      request: zio.aws.pinpoint.model.GetVoiceTemplateRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetVoiceTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVoiceTemplate(request))
  def deleteVoiceChannel(
      request: zio.aws.pinpoint.model.DeleteVoiceChannelRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.DeleteVoiceChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteVoiceChannel(request))
  def getApnsVoipChannel(
      request: zio.aws.pinpoint.model.GetApnsVoipChannelRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetApnsVoipChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getApnsVoipChannel(request))
  def createSegment(request: zio.aws.pinpoint.model.CreateSegmentRequest): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.CreateSegmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSegment(request))
  def deleteEmailChannel(
      request: zio.aws.pinpoint.model.DeleteEmailChannelRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.DeleteEmailChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEmailChannel(request))
  def getJourneyExecutionMetrics(
      request: zio.aws.pinpoint.model.GetJourneyExecutionMetricsRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetJourneyExecutionMetricsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getJourneyExecutionMetrics(request))
  def updateTemplateActiveVersion(
      request: zio.aws.pinpoint.model.UpdateTemplateActiveVersionRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.UpdateTemplateActiveVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateTemplateActiveVersion(request))
  def getJourneyDateRangeKpi(
      request: zio.aws.pinpoint.model.GetJourneyDateRangeKpiRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetJourneyDateRangeKpiResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getJourneyDateRangeKpi(request))
  def getJourney(request: zio.aws.pinpoint.model.GetJourneyRequest): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetJourneyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getJourney(request))
  def updateVoiceTemplate(
      request: zio.aws.pinpoint.model.UpdateVoiceTemplateRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.UpdateVoiceTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateVoiceTemplate(request))
  def deleteApnsVoipSandboxChannel(
      request: zio.aws.pinpoint.model.DeleteApnsVoipSandboxChannelRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.DeleteApnsVoipSandboxChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteApnsVoipSandboxChannel(request))
  def getApplicationDateRangeKpi(
      request: zio.aws.pinpoint.model.GetApplicationDateRangeKpiRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetApplicationDateRangeKpiResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getApplicationDateRangeKpi(request))
  def createCampaign(
      request: zio.aws.pinpoint.model.CreateCampaignRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.CreateCampaignResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCampaign(request))
  def listTagsForResource(
      request: zio.aws.pinpoint.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def getSegments(request: zio.aws.pinpoint.model.GetSegmentsRequest): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetSegmentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSegments(request))
  def updateEmailTemplate(
      request: zio.aws.pinpoint.model.UpdateEmailTemplateRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.UpdateEmailTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateEmailTemplate(request))
  def getExportJobs(request: zio.aws.pinpoint.model.GetExportJobsRequest): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetExportJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getExportJobs(request))
  def updateJourneyState(
      request: zio.aws.pinpoint.model.UpdateJourneyStateRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.UpdateJourneyStateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateJourneyState(request))
  def tagResource(
      request: zio.aws.pinpoint.model.TagResourceRequest
  ): ZIO[zio.aws.pinpoint.Pinpoint, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagResource(request))
  def getSmsChannel(request: zio.aws.pinpoint.model.GetSmsChannelRequest): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetSmsChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSmsChannel(request))
  def deleteInAppTemplate(
      request: zio.aws.pinpoint.model.DeleteInAppTemplateRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.DeleteInAppTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteInAppTemplate(request))
  def deleteRecommenderConfiguration(
      request: zio.aws.pinpoint.model.DeleteRecommenderConfigurationRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.DeleteRecommenderConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteRecommenderConfiguration(request))
  def updateEndpoint(
      request: zio.aws.pinpoint.model.UpdateEndpointRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.UpdateEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateEndpoint(request))
  def deleteApnsChannel(
      request: zio.aws.pinpoint.model.DeleteApnsChannelRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.DeleteApnsChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteApnsChannel(request))
  def deleteApnsVoipChannel(
      request: zio.aws.pinpoint.model.DeleteApnsVoipChannelRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.DeleteApnsVoipChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteApnsVoipChannel(request))
  def deletePushTemplate(
      request: zio.aws.pinpoint.model.DeletePushTemplateRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.DeletePushTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deletePushTemplate(request))
  def updateApnsVoipChannel(
      request: zio.aws.pinpoint.model.UpdateApnsVoipChannelRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.UpdateApnsVoipChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateApnsVoipChannel(request))
  def getPushTemplate(
      request: zio.aws.pinpoint.model.GetPushTemplateRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetPushTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPushTemplate(request))
  def getImportJob(request: zio.aws.pinpoint.model.GetImportJobRequest): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetImportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getImportJob(request))
  def getRecommenderConfiguration(
      request: zio.aws.pinpoint.model.GetRecommenderConfigurationRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetRecommenderConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRecommenderConfiguration(request))
  def sendUsersMessages(
      request: zio.aws.pinpoint.model.SendUsersMessagesRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.SendUsersMessagesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendUsersMessages(request))
  def deleteUserEndpoints(
      request: zio.aws.pinpoint.model.DeleteUserEndpointsRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.DeleteUserEndpointsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteUserEndpoints(request))
  def updateSmsChannel(
      request: zio.aws.pinpoint.model.UpdateSmsChannelRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.UpdateSmsChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSmsChannel(request))
  def getSegmentVersions(
      request: zio.aws.pinpoint.model.GetSegmentVersionsRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetSegmentVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSegmentVersions(request))
  def createVoiceTemplate(
      request: zio.aws.pinpoint.model.CreateVoiceTemplateRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.CreateVoiceTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVoiceTemplate(request))
  def putEventStream(
      request: zio.aws.pinpoint.model.PutEventStreamRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.PutEventStreamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putEventStream(request))
  def deleteBaiduChannel(
      request: zio.aws.pinpoint.model.DeleteBaiduChannelRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.DeleteBaiduChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteBaiduChannel(request))
  def deleteGcmChannel(
      request: zio.aws.pinpoint.model.DeleteGcmChannelRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.DeleteGcmChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteGcmChannel(request))
  def verifyOTPMessage(
      request: zio.aws.pinpoint.model.VerifyOtpMessageRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.VerifyOtpMessageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.verifyOTPMessage(request))
  def deleteVoiceTemplate(
      request: zio.aws.pinpoint.model.DeleteVoiceTemplateRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.DeleteVoiceTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteVoiceTemplate(request))
  def getRecommenderConfigurations(
      request: zio.aws.pinpoint.model.GetRecommenderConfigurationsRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetRecommenderConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRecommenderConfigurations(request))
  def getBaiduChannel(
      request: zio.aws.pinpoint.model.GetBaiduChannelRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.GetBaiduChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBaiduChannel(request))
  def updateCampaign(
      request: zio.aws.pinpoint.model.UpdateCampaignRequest
  ): ZIO[
    zio.aws.pinpoint.Pinpoint,
    AwsError,
    zio.aws.pinpoint.model.UpdateCampaignResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateCampaign(request))
}
