package zio.aws.pinpoint.model
import zio.prelude.data.Optional
import zio.aws.pinpoint.model.primitives.{__boolean, __integer, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class WriteCampaignRequest(
    additionalTreatments: Optional[
      Iterable[zio.aws.pinpoint.model.WriteTreatmentResource]
    ] = Optional.Absent,
    customDeliveryConfiguration: Optional[
      zio.aws.pinpoint.model.CustomDeliveryConfiguration
    ] = Optional.Absent,
    description: Optional[__string] = Optional.Absent,
    holdoutPercent: Optional[__integer] = Optional.Absent,
    hook: Optional[zio.aws.pinpoint.model.CampaignHook] = Optional.Absent,
    isPaused: Optional[__boolean] = Optional.Absent,
    limits: Optional[zio.aws.pinpoint.model.CampaignLimits] = Optional.Absent,
    messageConfiguration: Optional[
      zio.aws.pinpoint.model.MessageConfiguration
    ] = Optional.Absent,
    name: Optional[__string] = Optional.Absent,
    schedule: Optional[zio.aws.pinpoint.model.Schedule] = Optional.Absent,
    segmentId: Optional[__string] = Optional.Absent,
    segmentVersion: Optional[__integer] = Optional.Absent,
    tags: Optional[Map[__string, __string]] = Optional.Absent,
    templateConfiguration: Optional[
      zio.aws.pinpoint.model.TemplateConfiguration
    ] = Optional.Absent,
    treatmentDescription: Optional[__string] = Optional.Absent,
    treatmentName: Optional[__string] = Optional.Absent,
    priority: Optional[__integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.WriteCampaignRequest = {
    import WriteCampaignRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.WriteCampaignRequest
      .builder()
      .optionallyWith(
        additionalTreatments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.additionalTreatments)
      .optionallyWith(
        customDeliveryConfiguration.map(value => value.buildAwsValue())
      )(_.customDeliveryConfiguration)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(holdoutPercent.map(value => value: Integer))(
        _.holdoutPercent
      )
      .optionallyWith(hook.map(value => value.buildAwsValue()))(_.hook)
      .optionallyWith(isPaused.map(value => value: java.lang.Boolean))(
        _.isPaused
      )
      .optionallyWith(limits.map(value => value.buildAwsValue()))(_.limits)
      .optionallyWith(messageConfiguration.map(value => value.buildAwsValue()))(
        _.messageConfiguration
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(schedule.map(value => value.buildAwsValue()))(_.schedule)
      .optionallyWith(segmentId.map(value => value: java.lang.String))(
        _.segmentId
      )
      .optionallyWith(segmentVersion.map(value => value: Integer))(
        _.segmentVersion
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        templateConfiguration.map(value => value.buildAwsValue())
      )(_.templateConfiguration)
      .optionallyWith(
        treatmentDescription.map(value => value: java.lang.String)
      )(_.treatmentDescription)
      .optionallyWith(treatmentName.map(value => value: java.lang.String))(
        _.treatmentName
      )
      .optionallyWith(priority.map(value => value: Integer))(_.priority)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.WriteCampaignRequest.ReadOnly =
    zio.aws.pinpoint.model.WriteCampaignRequest.wrap(buildAwsValue())
}
object WriteCampaignRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.WriteCampaignRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.WriteCampaignRequest =
      zio.aws.pinpoint.model.WriteCampaignRequest(
        additionalTreatments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        customDeliveryConfiguration.map(value => value.asEditable),
        description.map(value => value),
        holdoutPercent.map(value => value),
        hook.map(value => value.asEditable),
        isPaused.map(value => value),
        limits.map(value => value.asEditable),
        messageConfiguration.map(value => value.asEditable),
        name.map(value => value),
        schedule.map(value => value.asEditable),
        segmentId.map(value => value),
        segmentVersion.map(value => value),
        tags.map(value => value),
        templateConfiguration.map(value => value.asEditable),
        treatmentDescription.map(value => value),
        treatmentName.map(value => value),
        priority.map(value => value)
      )
    def additionalTreatments
        : Optional[List[zio.aws.pinpoint.model.WriteTreatmentResource.ReadOnly]]
    def customDeliveryConfiguration
        : Optional[zio.aws.pinpoint.model.CustomDeliveryConfiguration.ReadOnly]
    def description: Optional[__string]
    def holdoutPercent: Optional[__integer]
    def hook: Optional[zio.aws.pinpoint.model.CampaignHook.ReadOnly]
    def isPaused: Optional[__boolean]
    def limits: Optional[zio.aws.pinpoint.model.CampaignLimits.ReadOnly]
    def messageConfiguration
        : Optional[zio.aws.pinpoint.model.MessageConfiguration.ReadOnly]
    def name: Optional[__string]
    def schedule: Optional[zio.aws.pinpoint.model.Schedule.ReadOnly]
    def segmentId: Optional[__string]
    def segmentVersion: Optional[__integer]
    def tags: Optional[Map[__string, __string]]
    def templateConfiguration
        : Optional[zio.aws.pinpoint.model.TemplateConfiguration.ReadOnly]
    def treatmentDescription: Optional[__string]
    def treatmentName: Optional[__string]
    def priority: Optional[__integer]
    def getAdditionalTreatments: ZIO[Any, AwsError, List[
      zio.aws.pinpoint.model.WriteTreatmentResource.ReadOnly
    ]] =
      AwsError.unwrapOptionField("additionalTreatments", additionalTreatments)
    def getCustomDeliveryConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.CustomDeliveryConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "customDeliveryConfiguration",
      customDeliveryConfiguration
    )
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getHoldoutPercent: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("holdoutPercent", holdoutPercent)
    def getHook
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.CampaignHook.ReadOnly] =
      AwsError.unwrapOptionField("hook", hook)
    def getIsPaused: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("isPaused", isPaused)
    def getLimits
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.CampaignLimits.ReadOnly] =
      AwsError.unwrapOptionField("limits", limits)
    def getMessageConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.MessageConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("messageConfiguration", messageConfiguration)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getSchedule
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.Schedule.ReadOnly] =
      AwsError.unwrapOptionField("schedule", schedule)
    def getSegmentId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("segmentId", segmentId)
    def getSegmentVersion: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("segmentVersion", segmentVersion)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTemplateConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.TemplateConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("templateConfiguration", templateConfiguration)
    def getTreatmentDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("treatmentDescription", treatmentDescription)
    def getTreatmentName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("treatmentName", treatmentName)
    def getPriority: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("priority", priority)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.WriteCampaignRequest
  ) extends zio.aws.pinpoint.model.WriteCampaignRequest.ReadOnly {
    override val additionalTreatments: Optional[
      List[zio.aws.pinpoint.model.WriteTreatmentResource.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalTreatments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpoint.model.WriteTreatmentResource.wrap(item)
        }.toList
      )
    override val customDeliveryConfiguration: Optional[
      zio.aws.pinpoint.model.CustomDeliveryConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customDeliveryConfiguration())
      .map(value =>
        zio.aws.pinpoint.model.CustomDeliveryConfiguration.wrap(value)
      )
    override val description: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: __string)
    override val holdoutPercent: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.holdoutPercent())
      .map(value => value: __integer)
    override val hook: Optional[zio.aws.pinpoint.model.CampaignHook.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hook())
        .map(value => zio.aws.pinpoint.model.CampaignHook.wrap(value))
    override val isPaused: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isPaused())
      .map(value => value: __boolean)
    override val limits
        : Optional[zio.aws.pinpoint.model.CampaignLimits.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.limits())
        .map(value => zio.aws.pinpoint.model.CampaignLimits.wrap(value))
    override val messageConfiguration
        : Optional[zio.aws.pinpoint.model.MessageConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messageConfiguration())
        .map(value => zio.aws.pinpoint.model.MessageConfiguration.wrap(value))
    override val name: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: __string)
    override val schedule: Optional[zio.aws.pinpoint.model.Schedule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schedule())
        .map(value => zio.aws.pinpoint.model.Schedule.wrap(value))
    override val segmentId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.segmentId())
      .map(value => value: __string)
    override val segmentVersion: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.segmentVersion())
      .map(value => value: __integer)
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val templateConfiguration
        : Optional[zio.aws.pinpoint.model.TemplateConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateConfiguration())
        .map(value => zio.aws.pinpoint.model.TemplateConfiguration.wrap(value))
    override val treatmentDescription: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.treatmentDescription())
        .map(value => value: __string)
    override val treatmentName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.treatmentName())
      .map(value => value: __string)
    override val priority: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value => value: __integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.WriteCampaignRequest
  ): zio.aws.pinpoint.model.WriteCampaignRequest.ReadOnly = new Wrapper(impl)
}
