package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__boolean
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class WriteApplicationSettingsRequest(
    campaignHook: Optional[zio.aws.pinpoint.model.CampaignHook] =
      Optional.Absent,
    cloudWatchMetricsEnabled: Optional[__boolean] = Optional.Absent,
    eventTaggingEnabled: Optional[__boolean] = Optional.Absent,
    limits: Optional[zio.aws.pinpoint.model.CampaignLimits] = Optional.Absent,
    quietTime: Optional[zio.aws.pinpoint.model.QuietTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.WriteApplicationSettingsRequest = {
    import WriteApplicationSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.WriteApplicationSettingsRequest
      .builder()
      .optionallyWith(campaignHook.map(value => value.buildAwsValue()))(
        _.campaignHook
      )
      .optionallyWith(
        cloudWatchMetricsEnabled.map(value => value: java.lang.Boolean)
      )(_.cloudWatchMetricsEnabled)
      .optionallyWith(
        eventTaggingEnabled.map(value => value: java.lang.Boolean)
      )(_.eventTaggingEnabled)
      .optionallyWith(limits.map(value => value.buildAwsValue()))(_.limits)
      .optionallyWith(quietTime.map(value => value.buildAwsValue()))(
        _.quietTime
      )
      .build()
  }
  def asReadOnly
      : zio.aws.pinpoint.model.WriteApplicationSettingsRequest.ReadOnly =
    zio.aws.pinpoint.model.WriteApplicationSettingsRequest.wrap(buildAwsValue())
}
object WriteApplicationSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.WriteApplicationSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.WriteApplicationSettingsRequest =
      zio.aws.pinpoint.model.WriteApplicationSettingsRequest(
        campaignHook.map(value => value.asEditable),
        cloudWatchMetricsEnabled.map(value => value),
        eventTaggingEnabled.map(value => value),
        limits.map(value => value.asEditable),
        quietTime.map(value => value.asEditable)
      )
    def campaignHook: Optional[zio.aws.pinpoint.model.CampaignHook.ReadOnly]
    def cloudWatchMetricsEnabled: Optional[__boolean]
    def eventTaggingEnabled: Optional[__boolean]
    def limits: Optional[zio.aws.pinpoint.model.CampaignLimits.ReadOnly]
    def quietTime: Optional[zio.aws.pinpoint.model.QuietTime.ReadOnly]
    def getCampaignHook
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.CampaignHook.ReadOnly] =
      AwsError.unwrapOptionField("campaignHook", campaignHook)
    def getCloudWatchMetricsEnabled: ZIO[Any, AwsError, __boolean] = AwsError
      .unwrapOptionField("cloudWatchMetricsEnabled", cloudWatchMetricsEnabled)
    def getEventTaggingEnabled: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("eventTaggingEnabled", eventTaggingEnabled)
    def getLimits
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.CampaignLimits.ReadOnly] =
      AwsError.unwrapOptionField("limits", limits)
    def getQuietTime
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.QuietTime.ReadOnly] =
      AwsError.unwrapOptionField("quietTime", quietTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.WriteApplicationSettingsRequest
  ) extends zio.aws.pinpoint.model.WriteApplicationSettingsRequest.ReadOnly {
    override val campaignHook
        : Optional[zio.aws.pinpoint.model.CampaignHook.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.campaignHook())
        .map(value => zio.aws.pinpoint.model.CampaignHook.wrap(value))
    override val cloudWatchMetricsEnabled: Optional[__boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchMetricsEnabled())
        .map(value => value: __boolean)
    override val eventTaggingEnabled: Optional[__boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventTaggingEnabled())
        .map(value => value: __boolean)
    override val limits
        : Optional[zio.aws.pinpoint.model.CampaignLimits.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.limits())
        .map(value => zio.aws.pinpoint.model.CampaignLimits.wrap(value))
    override val quietTime
        : Optional[zio.aws.pinpoint.model.QuietTime.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.quietTime())
        .map(value => zio.aws.pinpoint.model.QuietTime.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.WriteApplicationSettingsRequest
  ): zio.aws.pinpoint.model.WriteApplicationSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
