package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class WaitTime(
    waitFor: Optional[__string] = Optional.Absent,
    waitUntil: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.WaitTime = {
    import WaitTime.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.WaitTime
      .builder()
      .optionallyWith(waitFor.map(value => value: java.lang.String))(_.waitFor)
      .optionallyWith(waitUntil.map(value => value: java.lang.String))(
        _.waitUntil
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.WaitTime.ReadOnly =
    zio.aws.pinpoint.model.WaitTime.wrap(buildAwsValue())
}
object WaitTime {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.pinpoint.model.WaitTime] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.WaitTime = zio.aws.pinpoint.model
      .WaitTime(waitFor.map(value => value), waitUntil.map(value => value))
    def waitFor: Optional[__string]
    def waitUntil: Optional[__string]
    def getWaitFor: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("waitFor", waitFor)
    def getWaitUntil: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("waitUntil", waitUntil)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.WaitTime
  ) extends zio.aws.pinpoint.model.WaitTime.ReadOnly {
    override val waitFor: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.waitFor())
      .map(value => value: __string)
    override val waitUntil: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.waitUntil())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.WaitTime
  ): zio.aws.pinpoint.model.WaitTime.ReadOnly = new Wrapper(impl)
}
