package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VoiceMessage(
    body: Optional[__string] = Optional.Absent,
    languageCode: Optional[__string] = Optional.Absent,
    originationNumber: Optional[__string] = Optional.Absent,
    substitutions: Optional[Map[__string, Iterable[__string]]] =
      Optional.Absent,
    voiceId: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.VoiceMessage = {
    import VoiceMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.VoiceMessage
      .builder()
      .optionallyWith(body.map(value => value: java.lang.String))(_.body)
      .optionallyWith(languageCode.map(value => value: java.lang.String))(
        _.languageCode
      )
      .optionallyWith(originationNumber.map(value => value: java.lang.String))(
        _.originationNumber
      )
      .optionallyWith(
        substitutions.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.map { item =>
                item: java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.substitutions)
      .optionallyWith(voiceId.map(value => value: java.lang.String))(_.voiceId)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.VoiceMessage.ReadOnly =
    zio.aws.pinpoint.model.VoiceMessage.wrap(buildAwsValue())
}
object VoiceMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.VoiceMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.VoiceMessage =
      zio.aws.pinpoint.model.VoiceMessage(
        body.map(value => value),
        languageCode.map(value => value),
        originationNumber.map(value => value),
        substitutions.map(value => value),
        voiceId.map(value => value)
      )
    def body: Optional[__string]
    def languageCode: Optional[__string]
    def originationNumber: Optional[__string]
    def substitutions: Optional[Map[__string, List[__string]]]
    def voiceId: Optional[__string]
    def getBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("body", body)
    def getLanguageCode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getOriginationNumber: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("originationNumber", originationNumber)
    def getSubstitutions: ZIO[Any, AwsError, Map[__string, List[__string]]] =
      AwsError.unwrapOptionField("substitutions", substitutions)
    def getVoiceId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("voiceId", voiceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.VoiceMessage
  ) extends zio.aws.pinpoint.model.VoiceMessage.ReadOnly {
    override val body: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.body())
      .map(value => value: __string)
    override val languageCode: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.languageCode())
      .map(value => value: __string)
    override val originationNumber: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.originationNumber())
      .map(value => value: __string)
    override val substitutions: Optional[Map[__string, List[__string]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.substitutions())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> value.asScala.map { item =>
                item: __string
              }.toList
            })
            .toMap
        )
    override val voiceId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.voiceId())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.VoiceMessage
  ): zio.aws.pinpoint.model.VoiceMessage.ReadOnly = new Wrapper(impl)
}
