package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__string, __boolean}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateSmsTemplateRequest(
    createNewVersion: Optional[__boolean] = Optional.Absent,
    smsTemplateRequest: zio.aws.pinpoint.model.SMSTemplateRequest,
    templateName: __string,
    version: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.UpdateSmsTemplateRequest = {
    import UpdateSmsTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.UpdateSmsTemplateRequest
      .builder()
      .optionallyWith(createNewVersion.map(value => value: java.lang.Boolean))(
        _.createNewVersion
      )
      .smsTemplateRequest(smsTemplateRequest.buildAwsValue())
      .templateName(templateName: java.lang.String)
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.UpdateSmsTemplateRequest.ReadOnly =
    zio.aws.pinpoint.model.UpdateSmsTemplateRequest.wrap(buildAwsValue())
}
object UpdateSmsTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.UpdateSmsTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.UpdateSmsTemplateRequest =
      zio.aws.pinpoint.model.UpdateSmsTemplateRequest(
        createNewVersion.map(value => value),
        smsTemplateRequest.asEditable,
        templateName,
        version.map(value => value)
      )
    def createNewVersion: Optional[__boolean]
    def smsTemplateRequest: zio.aws.pinpoint.model.SMSTemplateRequest.ReadOnly
    def templateName: __string
    def version: Optional[__string]
    def getCreateNewVersion: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("createNewVersion", createNewVersion)
    def getSmsTemplateRequest: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.SMSTemplateRequest.ReadOnly
    ] = ZIO.succeed(smsTemplateRequest)
    def getTemplateName: ZIO[Any, Nothing, __string] = ZIO.succeed(templateName)
    def getVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateSmsTemplateRequest
  ) extends zio.aws.pinpoint.model.UpdateSmsTemplateRequest.ReadOnly {
    override val createNewVersion: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.createNewVersion())
      .map(value => value: __boolean)
    override val smsTemplateRequest
        : zio.aws.pinpoint.model.SMSTemplateRequest.ReadOnly =
      zio.aws.pinpoint.model.SMSTemplateRequest.wrap(impl.smsTemplateRequest())
    override val templateName: __string = impl.templateName(): __string
    override val version: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateSmsTemplateRequest
  ): zio.aws.pinpoint.model.UpdateSmsTemplateRequest.ReadOnly = new Wrapper(
    impl
  )
}
