package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateSegmentResponse(
    segmentResponse: zio.aws.pinpoint.model.SegmentResponse
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.UpdateSegmentResponse = {
    import UpdateSegmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.UpdateSegmentResponse
      .builder()
      .segmentResponse(segmentResponse.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.UpdateSegmentResponse.ReadOnly =
    zio.aws.pinpoint.model.UpdateSegmentResponse.wrap(buildAwsValue())
}
object UpdateSegmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.UpdateSegmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.UpdateSegmentResponse =
      zio.aws.pinpoint.model.UpdateSegmentResponse(segmentResponse.asEditable)
    def segmentResponse: zio.aws.pinpoint.model.SegmentResponse.ReadOnly
    def getSegmentResponse
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.SegmentResponse.ReadOnly] =
      ZIO.succeed(segmentResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateSegmentResponse
  ) extends zio.aws.pinpoint.model.UpdateSegmentResponse.ReadOnly {
    override val segmentResponse
        : zio.aws.pinpoint.model.SegmentResponse.ReadOnly =
      zio.aws.pinpoint.model.SegmentResponse.wrap(impl.segmentResponse())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateSegmentResponse
  ): zio.aws.pinpoint.model.UpdateSegmentResponse.ReadOnly = new Wrapper(impl)
}
