package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdatePushTemplateResponse(
    messageBody: zio.aws.pinpoint.model.MessageBody
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.UpdatePushTemplateResponse = {
    import UpdatePushTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.UpdatePushTemplateResponse
      .builder()
      .messageBody(messageBody.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.UpdatePushTemplateResponse.ReadOnly =
    zio.aws.pinpoint.model.UpdatePushTemplateResponse.wrap(buildAwsValue())
}
object UpdatePushTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.UpdatePushTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.UpdatePushTemplateResponse =
      zio.aws.pinpoint.model.UpdatePushTemplateResponse(messageBody.asEditable)
    def messageBody: zio.aws.pinpoint.model.MessageBody.ReadOnly
    def getMessageBody
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.MessageBody.ReadOnly] =
      ZIO.succeed(messageBody)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdatePushTemplateResponse
  ) extends zio.aws.pinpoint.model.UpdatePushTemplateResponse.ReadOnly {
    override val messageBody: zio.aws.pinpoint.model.MessageBody.ReadOnly =
      zio.aws.pinpoint.model.MessageBody.wrap(impl.messageBody())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdatePushTemplateResponse
  ): zio.aws.pinpoint.model.UpdatePushTemplateResponse.ReadOnly = new Wrapper(
    impl
  )
}
