package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateCampaignResponse(
    campaignResponse: zio.aws.pinpoint.model.CampaignResponse
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.UpdateCampaignResponse = {
    import UpdateCampaignResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.UpdateCampaignResponse
      .builder()
      .campaignResponse(campaignResponse.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.UpdateCampaignResponse.ReadOnly =
    zio.aws.pinpoint.model.UpdateCampaignResponse.wrap(buildAwsValue())
}
object UpdateCampaignResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.UpdateCampaignResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.UpdateCampaignResponse =
      zio.aws.pinpoint.model.UpdateCampaignResponse(campaignResponse.asEditable)
    def campaignResponse: zio.aws.pinpoint.model.CampaignResponse.ReadOnly
    def getCampaignResponse
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.CampaignResponse.ReadOnly] =
      ZIO.succeed(campaignResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateCampaignResponse
  ) extends zio.aws.pinpoint.model.UpdateCampaignResponse.ReadOnly {
    override val campaignResponse
        : zio.aws.pinpoint.model.CampaignResponse.ReadOnly =
      zio.aws.pinpoint.model.CampaignResponse.wrap(impl.campaignResponse())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateCampaignResponse
  ): zio.aws.pinpoint.model.UpdateCampaignResponse.ReadOnly = new Wrapper(impl)
}
