package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateApplicationSettingsResponse(
    applicationSettingsResource: zio.aws.pinpoint.model.ApplicationSettingsResource
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.UpdateApplicationSettingsResponse = {
    import UpdateApplicationSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.UpdateApplicationSettingsResponse
      .builder()
      .applicationSettingsResource(applicationSettingsResource.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.pinpoint.model.UpdateApplicationSettingsResponse.ReadOnly =
    zio.aws.pinpoint.model.UpdateApplicationSettingsResponse
      .wrap(buildAwsValue())
}
object UpdateApplicationSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.UpdateApplicationSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.UpdateApplicationSettingsResponse =
      zio.aws.pinpoint.model.UpdateApplicationSettingsResponse(
        applicationSettingsResource.asEditable
      )
    def applicationSettingsResource
        : zio.aws.pinpoint.model.ApplicationSettingsResource.ReadOnly
    def getApplicationSettingsResource: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.ApplicationSettingsResource.ReadOnly
    ] = ZIO.succeed(applicationSettingsResource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateApplicationSettingsResponse
  ) extends zio.aws.pinpoint.model.UpdateApplicationSettingsResponse.ReadOnly {
    override val applicationSettingsResource
        : zio.aws.pinpoint.model.ApplicationSettingsResource.ReadOnly =
      zio.aws.pinpoint.model.ApplicationSettingsResource
        .wrap(impl.applicationSettingsResource())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateApplicationSettingsResponse
  ): zio.aws.pinpoint.model.UpdateApplicationSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
