package zio.aws.pinpoint.model
import scala.jdk.CollectionConverters.*
sealed trait Type {
  def unwrap: software.amazon.awssdk.services.pinpoint.model.Type
}
object Type {
  def wrap(
      value: software.amazon.awssdk.services.pinpoint.model.Type
  ): zio.aws.pinpoint.model.Type = value match {
    case software.amazon.awssdk.services.pinpoint.model.Type.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pinpoint.model.Type.ALL =>
      val r = ALL
      r
    case software.amazon.awssdk.services.pinpoint.model.Type.ANY =>
      val r = ANY
      r
    case software.amazon.awssdk.services.pinpoint.model.Type.NONE =>
      val r = NONE
      r
  }
  case object unknownToSdkVersion extends zio.aws.pinpoint.model.Type {
    override def unwrap: software.amazon.awssdk.services.pinpoint.model.Type =
      software.amazon.awssdk.services.pinpoint.model.Type.UNKNOWN_TO_SDK_VERSION
  }
  case object ALL extends zio.aws.pinpoint.model.Type {
    override def unwrap: software.amazon.awssdk.services.pinpoint.model.Type =
      software.amazon.awssdk.services.pinpoint.model.Type.ALL
  }
  case object ANY extends zio.aws.pinpoint.model.Type {
    override def unwrap: software.amazon.awssdk.services.pinpoint.model.Type =
      software.amazon.awssdk.services.pinpoint.model.Type.ANY
  }
  case object NONE extends zio.aws.pinpoint.model.Type {
    override def unwrap: software.amazon.awssdk.services.pinpoint.model.Type =
      software.amazon.awssdk.services.pinpoint.model.Type.NONE
  }
}
