package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TemplateResponse(
    arn: Optional[__string] = Optional.Absent,
    creationDate: __string,
    defaultSubstitutions: Optional[__string] = Optional.Absent,
    lastModifiedDate: __string,
    tags: Optional[Map[__string, __string]] = Optional.Absent,
    templateDescription: Optional[__string] = Optional.Absent,
    templateName: __string,
    templateType: zio.aws.pinpoint.model.TemplateType,
    version: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.TemplateResponse = {
    import TemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.TemplateResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .creationDate(creationDate: java.lang.String)
      .optionallyWith(
        defaultSubstitutions.map(value => value: java.lang.String)
      )(_.defaultSubstitutions)
      .lastModifiedDate(lastModifiedDate: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        templateDescription.map(value => value: java.lang.String)
      )(_.templateDescription)
      .templateName(templateName: java.lang.String)
      .templateType(templateType.unwrap)
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.TemplateResponse.ReadOnly =
    zio.aws.pinpoint.model.TemplateResponse.wrap(buildAwsValue())
}
object TemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.TemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.TemplateResponse =
      zio.aws.pinpoint.model.TemplateResponse(
        arn.map(value => value),
        creationDate,
        defaultSubstitutions.map(value => value),
        lastModifiedDate,
        tags.map(value => value),
        templateDescription.map(value => value),
        templateName,
        templateType,
        version.map(value => value)
      )
    def arn: Optional[__string]
    def creationDate: __string
    def defaultSubstitutions: Optional[__string]
    def lastModifiedDate: __string
    def tags: Optional[Map[__string, __string]]
    def templateDescription: Optional[__string]
    def templateName: __string
    def templateType: zio.aws.pinpoint.model.TemplateType
    def version: Optional[__string]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreationDate: ZIO[Any, Nothing, __string] = ZIO.succeed(creationDate)
    def getDefaultSubstitutions: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("defaultSubstitutions", defaultSubstitutions)
    def getLastModifiedDate: ZIO[Any, Nothing, __string] =
      ZIO.succeed(lastModifiedDate)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTemplateDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateDescription", templateDescription)
    def getTemplateName: ZIO[Any, Nothing, __string] = ZIO.succeed(templateName)
    def getTemplateType
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.TemplateType] =
      ZIO.succeed(templateType)
    def getVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.TemplateResponse
  ) extends zio.aws.pinpoint.model.TemplateResponse.ReadOnly {
    override val arn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: __string)
    override val creationDate: __string = impl.creationDate(): __string
    override val defaultSubstitutions: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultSubstitutions())
        .map(value => value: __string)
    override val lastModifiedDate: __string = impl.lastModifiedDate(): __string
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val templateDescription: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.templateDescription())
      .map(value => value: __string)
    override val templateName: __string = impl.templateName(): __string
    override val templateType: zio.aws.pinpoint.model.TemplateType =
      zio.aws.pinpoint.model.TemplateType.wrap(impl.templateType())
    override val version: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.TemplateResponse
  ): zio.aws.pinpoint.model.TemplateResponse.ReadOnly = new Wrapper(impl)
}
