package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TemplateActiveVersionRequest(
    version: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.TemplateActiveVersionRequest = {
    import TemplateActiveVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.TemplateActiveVersionRequest
      .builder()
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.TemplateActiveVersionRequest.ReadOnly =
    zio.aws.pinpoint.model.TemplateActiveVersionRequest.wrap(buildAwsValue())
}
object TemplateActiveVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.TemplateActiveVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.TemplateActiveVersionRequest =
      zio.aws.pinpoint.model
        .TemplateActiveVersionRequest(version.map(value => value))
    def version: Optional[__string]
    def getVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.TemplateActiveVersionRequest
  ) extends zio.aws.pinpoint.model.TemplateActiveVersionRequest.ReadOnly {
    override val version: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.TemplateActiveVersionRequest
  ): zio.aws.pinpoint.model.TemplateActiveVersionRequest.ReadOnly = new Wrapper(
    impl
  )
}
