package zio.aws.pinpoint.model
import scala.jdk.CollectionConverters.*
sealed trait State {
  def unwrap: software.amazon.awssdk.services.pinpoint.model.State
}
object State {
  def wrap(
      value: software.amazon.awssdk.services.pinpoint.model.State
  ): zio.aws.pinpoint.model.State = value match {
    case software.amazon.awssdk.services.pinpoint.model.State.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pinpoint.model.State.DRAFT =>
      val r = DRAFT
      r
    case software.amazon.awssdk.services.pinpoint.model.State.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.pinpoint.model.State.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.pinpoint.model.State.CANCELLED =>
      val r = CANCELLED
      r
    case software.amazon.awssdk.services.pinpoint.model.State.CLOSED =>
      val r = CLOSED
      r
    case software.amazon.awssdk.services.pinpoint.model.State.PAUSED =>
      val r = PAUSED
      r
  }
  case object unknownToSdkVersion extends zio.aws.pinpoint.model.State {
    override def unwrap: software.amazon.awssdk.services.pinpoint.model.State =
      software.amazon.awssdk.services.pinpoint.model.State.UNKNOWN_TO_SDK_VERSION
  }
  case object DRAFT extends zio.aws.pinpoint.model.State {
    override def unwrap: software.amazon.awssdk.services.pinpoint.model.State =
      software.amazon.awssdk.services.pinpoint.model.State.DRAFT
  }
  case object ACTIVE extends zio.aws.pinpoint.model.State {
    override def unwrap: software.amazon.awssdk.services.pinpoint.model.State =
      software.amazon.awssdk.services.pinpoint.model.State.ACTIVE
  }
  case object COMPLETED extends zio.aws.pinpoint.model.State {
    override def unwrap: software.amazon.awssdk.services.pinpoint.model.State =
      software.amazon.awssdk.services.pinpoint.model.State.COMPLETED
  }
  case object CANCELLED extends zio.aws.pinpoint.model.State {
    override def unwrap: software.amazon.awssdk.services.pinpoint.model.State =
      software.amazon.awssdk.services.pinpoint.model.State.CANCELLED
  }
  case object CLOSED extends zio.aws.pinpoint.model.State {
    override def unwrap: software.amazon.awssdk.services.pinpoint.model.State =
      software.amazon.awssdk.services.pinpoint.model.State.CLOSED
  }
  case object PAUSED extends zio.aws.pinpoint.model.State {
    override def unwrap: software.amazon.awssdk.services.pinpoint.model.State =
      software.amazon.awssdk.services.pinpoint.model.State.PAUSED
  }
}
