package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SimpleEmailPart(
    charset: Optional[__string] = Optional.Absent,
    data: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.SimpleEmailPart = {
    import SimpleEmailPart.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.SimpleEmailPart
      .builder()
      .optionallyWith(charset.map(value => value: java.lang.String))(_.charset)
      .optionallyWith(data.map(value => value: java.lang.String))(_.data)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.SimpleEmailPart.ReadOnly =
    zio.aws.pinpoint.model.SimpleEmailPart.wrap(buildAwsValue())
}
object SimpleEmailPart {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.SimpleEmailPart
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.SimpleEmailPart =
      zio.aws.pinpoint.model
        .SimpleEmailPart(charset.map(value => value), data.map(value => value))
    def charset: Optional[__string]
    def data: Optional[__string]
    def getCharset: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("charset", charset)
    def getData: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("data", data)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.SimpleEmailPart
  ) extends zio.aws.pinpoint.model.SimpleEmailPart.ReadOnly {
    override val charset: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.charset())
      .map(value => value: __string)
    override val data: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.data())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.SimpleEmailPart
  ): zio.aws.pinpoint.model.SimpleEmailPart.ReadOnly = new Wrapper(impl)
}
