package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SimpleCondition(
    eventCondition: Optional[zio.aws.pinpoint.model.EventCondition] =
      Optional.Absent,
    segmentCondition: Optional[zio.aws.pinpoint.model.SegmentCondition] =
      Optional.Absent,
    segmentDimensions: Optional[zio.aws.pinpoint.model.SegmentDimensions] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.SimpleCondition = {
    import SimpleCondition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.SimpleCondition
      .builder()
      .optionallyWith(eventCondition.map(value => value.buildAwsValue()))(
        _.eventCondition
      )
      .optionallyWith(segmentCondition.map(value => value.buildAwsValue()))(
        _.segmentCondition
      )
      .optionallyWith(segmentDimensions.map(value => value.buildAwsValue()))(
        _.segmentDimensions
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.SimpleCondition.ReadOnly =
    zio.aws.pinpoint.model.SimpleCondition.wrap(buildAwsValue())
}
object SimpleCondition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.SimpleCondition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.SimpleCondition =
      zio.aws.pinpoint.model.SimpleCondition(
        eventCondition.map(value => value.asEditable),
        segmentCondition.map(value => value.asEditable),
        segmentDimensions.map(value => value.asEditable)
      )
    def eventCondition: Optional[zio.aws.pinpoint.model.EventCondition.ReadOnly]
    def segmentCondition
        : Optional[zio.aws.pinpoint.model.SegmentCondition.ReadOnly]
    def segmentDimensions
        : Optional[zio.aws.pinpoint.model.SegmentDimensions.ReadOnly]
    def getEventCondition
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.EventCondition.ReadOnly] =
      AwsError.unwrapOptionField("eventCondition", eventCondition)
    def getSegmentCondition
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.SegmentCondition.ReadOnly] =
      AwsError.unwrapOptionField("segmentCondition", segmentCondition)
    def getSegmentDimensions: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.SegmentDimensions.ReadOnly
    ] = AwsError.unwrapOptionField("segmentDimensions", segmentDimensions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.SimpleCondition
  ) extends zio.aws.pinpoint.model.SimpleCondition.ReadOnly {
    override val eventCondition
        : Optional[zio.aws.pinpoint.model.EventCondition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventCondition())
        .map(value => zio.aws.pinpoint.model.EventCondition.wrap(value))
    override val segmentCondition
        : Optional[zio.aws.pinpoint.model.SegmentCondition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.segmentCondition())
        .map(value => zio.aws.pinpoint.model.SegmentCondition.wrap(value))
    override val segmentDimensions
        : Optional[zio.aws.pinpoint.model.SegmentDimensions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.segmentDimensions())
        .map(value => zio.aws.pinpoint.model.SegmentDimensions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.SimpleCondition
  ): zio.aws.pinpoint.model.SimpleCondition.ReadOnly = new Wrapper(impl)
}
