package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SendUsersMessageRequest(
    context: Optional[Map[__string, __string]] = Optional.Absent,
    messageConfiguration: zio.aws.pinpoint.model.DirectMessageConfiguration,
    templateConfiguration: Optional[
      zio.aws.pinpoint.model.TemplateConfiguration
    ] = Optional.Absent,
    traceId: Optional[__string] = Optional.Absent,
    users: Map[__string, zio.aws.pinpoint.model.EndpointSendConfiguration]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.SendUsersMessageRequest = {
    import SendUsersMessageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.SendUsersMessageRequest
      .builder()
      .optionallyWith(
        context.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.context)
      .messageConfiguration(messageConfiguration.buildAwsValue())
      .optionallyWith(
        templateConfiguration.map(value => value.buildAwsValue())
      )(_.templateConfiguration)
      .optionallyWith(traceId.map(value => value: java.lang.String))(_.traceId)
      .users(
        users
          .map({ case (key, value) =>
            (key: java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.SendUsersMessageRequest.ReadOnly =
    zio.aws.pinpoint.model.SendUsersMessageRequest.wrap(buildAwsValue())
}
object SendUsersMessageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.SendUsersMessageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.SendUsersMessageRequest =
      zio.aws.pinpoint.model.SendUsersMessageRequest(
        context.map(value => value),
        messageConfiguration.asEditable,
        templateConfiguration.map(value => value.asEditable),
        traceId.map(value => value),
        users.map({ case (key, value) =>
          key -> value.asEditable
        })
      )
    def context: Optional[Map[__string, __string]]
    def messageConfiguration
        : zio.aws.pinpoint.model.DirectMessageConfiguration.ReadOnly
    def templateConfiguration
        : Optional[zio.aws.pinpoint.model.TemplateConfiguration.ReadOnly]
    def traceId: Optional[__string]
    def users: Map[
      __string,
      zio.aws.pinpoint.model.EndpointSendConfiguration.ReadOnly
    ]
    def getContext: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("context", context)
    def getMessageConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.DirectMessageConfiguration.ReadOnly
    ] = ZIO.succeed(messageConfiguration)
    def getTemplateConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.TemplateConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("templateConfiguration", templateConfiguration)
    def getTraceId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("traceId", traceId)
    def getUsers: ZIO[Any, Nothing, Map[
      __string,
      zio.aws.pinpoint.model.EndpointSendConfiguration.ReadOnly
    ]] = ZIO.succeed(users)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.SendUsersMessageRequest
  ) extends zio.aws.pinpoint.model.SendUsersMessageRequest.ReadOnly {
    override val context: Optional[Map[__string, __string]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.context())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> (value: __string)
            })
            .toMap
        )
    override val messageConfiguration
        : zio.aws.pinpoint.model.DirectMessageConfiguration.ReadOnly =
      zio.aws.pinpoint.model.DirectMessageConfiguration
        .wrap(impl.messageConfiguration())
    override val templateConfiguration
        : Optional[zio.aws.pinpoint.model.TemplateConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateConfiguration())
        .map(value => zio.aws.pinpoint.model.TemplateConfiguration.wrap(value))
    override val traceId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.traceId())
      .map(value => value: __string)
    override val users: Map[
      __string,
      zio.aws.pinpoint.model.EndpointSendConfiguration.ReadOnly
    ] = impl
      .users()
      .asScala
      .map({ case (key, value) =>
        (key: __string) -> zio.aws.pinpoint.model.EndpointSendConfiguration
          .wrap(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.SendUsersMessageRequest
  ): zio.aws.pinpoint.model.SendUsersMessageRequest.ReadOnly = new Wrapper(impl)
}
