package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SendOtpMessageResponse(
    messageResponse: zio.aws.pinpoint.model.MessageResponse
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.SendOtpMessageResponse = {
    import SendOtpMessageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.SendOtpMessageResponse
      .builder()
      .messageResponse(messageResponse.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.SendOtpMessageResponse.ReadOnly =
    zio.aws.pinpoint.model.SendOtpMessageResponse.wrap(buildAwsValue())
}
object SendOtpMessageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.SendOtpMessageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.SendOtpMessageResponse =
      zio.aws.pinpoint.model.SendOtpMessageResponse(messageResponse.asEditable)
    def messageResponse: zio.aws.pinpoint.model.MessageResponse.ReadOnly
    def getMessageResponse
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.MessageResponse.ReadOnly] =
      ZIO.succeed(messageResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.SendOtpMessageResponse
  ) extends zio.aws.pinpoint.model.SendOtpMessageResponse.ReadOnly {
    override val messageResponse
        : zio.aws.pinpoint.model.MessageResponse.ReadOnly =
      zio.aws.pinpoint.model.MessageResponse.wrap(impl.messageResponse())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.SendOtpMessageResponse
  ): zio.aws.pinpoint.model.SendOtpMessageResponse.ReadOnly = new Wrapper(impl)
}
