package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class SendMessagesRequest(
    applicationId: __string,
    messageRequest: zio.aws.pinpoint.model.MessageRequest
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.SendMessagesRequest = {
    import SendMessagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.SendMessagesRequest
      .builder()
      .applicationId(applicationId: java.lang.String)
      .messageRequest(messageRequest.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.SendMessagesRequest.ReadOnly =
    zio.aws.pinpoint.model.SendMessagesRequest.wrap(buildAwsValue())
}
object SendMessagesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.SendMessagesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.SendMessagesRequest =
      zio.aws.pinpoint.model
        .SendMessagesRequest(applicationId, messageRequest.asEditable)
    def applicationId: __string
    def messageRequest: zio.aws.pinpoint.model.MessageRequest.ReadOnly
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getMessageRequest
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.MessageRequest.ReadOnly] =
      ZIO.succeed(messageRequest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.SendMessagesRequest
  ) extends zio.aws.pinpoint.model.SendMessagesRequest.ReadOnly {
    override val applicationId: __string = impl.applicationId(): __string
    override val messageRequest
        : zio.aws.pinpoint.model.MessageRequest.ReadOnly =
      zio.aws.pinpoint.model.MessageRequest.wrap(impl.messageRequest())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.SendMessagesRequest
  ): zio.aws.pinpoint.model.SendMessagesRequest.ReadOnly = new Wrapper(impl)
}
