package zio.aws.pinpoint.model
import scala.jdk.CollectionConverters.*
sealed trait SegmentType {
  def unwrap: software.amazon.awssdk.services.pinpoint.model.SegmentType
}
object SegmentType {
  def wrap(
      value: software.amazon.awssdk.services.pinpoint.model.SegmentType
  ): zio.aws.pinpoint.model.SegmentType = value match {
    case software.amazon.awssdk.services.pinpoint.model.SegmentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pinpoint.model.SegmentType.DIMENSIONAL =>
      val r = DIMENSIONAL
      r
    case software.amazon.awssdk.services.pinpoint.model.SegmentType.IMPORT =>
      val r = IMPORT
      r
  }
  case object unknownToSdkVersion extends zio.aws.pinpoint.model.SegmentType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.SegmentType =
      software.amazon.awssdk.services.pinpoint.model.SegmentType.UNKNOWN_TO_SDK_VERSION
  }
  case object DIMENSIONAL extends zio.aws.pinpoint.model.SegmentType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.SegmentType =
      software.amazon.awssdk.services.pinpoint.model.SegmentType.DIMENSIONAL
  }
  case object IMPORT extends zio.aws.pinpoint.model.SegmentType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.SegmentType =
      software.amazon.awssdk.services.pinpoint.model.SegmentType.IMPORT
  }
}
