package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SegmentDimensions(
    attributes: Optional[
      Map[__string, zio.aws.pinpoint.model.AttributeDimension]
    ] = Optional.Absent,
    behavior: Optional[zio.aws.pinpoint.model.SegmentBehaviors] =
      Optional.Absent,
    demographic: Optional[zio.aws.pinpoint.model.SegmentDemographics] =
      Optional.Absent,
    location: Optional[zio.aws.pinpoint.model.SegmentLocation] =
      Optional.Absent,
    metrics: Optional[Map[__string, zio.aws.pinpoint.model.MetricDimension]] =
      Optional.Absent,
    userAttributes: Optional[
      Map[__string, zio.aws.pinpoint.model.AttributeDimension]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.SegmentDimensions = {
    import SegmentDimensions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.SegmentDimensions
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.attributes)
      .optionallyWith(behavior.map(value => value.buildAwsValue()))(_.behavior)
      .optionallyWith(demographic.map(value => value.buildAwsValue()))(
        _.demographic
      )
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(
        metrics.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.metrics)
      .optionallyWith(
        userAttributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.userAttributes)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.SegmentDimensions.ReadOnly =
    zio.aws.pinpoint.model.SegmentDimensions.wrap(buildAwsValue())
}
object SegmentDimensions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.SegmentDimensions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.SegmentDimensions =
      zio.aws.pinpoint.model.SegmentDimensions(
        attributes.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        behavior.map(value => value.asEditable),
        demographic.map(value => value.asEditable),
        location.map(value => value.asEditable),
        metrics.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        userAttributes.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def attributes: Optional[
      Map[__string, zio.aws.pinpoint.model.AttributeDimension.ReadOnly]
    ]
    def behavior: Optional[zio.aws.pinpoint.model.SegmentBehaviors.ReadOnly]
    def demographic
        : Optional[zio.aws.pinpoint.model.SegmentDemographics.ReadOnly]
    def location: Optional[zio.aws.pinpoint.model.SegmentLocation.ReadOnly]
    def metrics: Optional[
      Map[__string, zio.aws.pinpoint.model.MetricDimension.ReadOnly]
    ]
    def userAttributes: Optional[
      Map[__string, zio.aws.pinpoint.model.AttributeDimension.ReadOnly]
    ]
    def getAttributes: ZIO[Any, AwsError, Map[
      __string,
      zio.aws.pinpoint.model.AttributeDimension.ReadOnly
    ]] = AwsError.unwrapOptionField("attributes", attributes)
    def getBehavior
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.SegmentBehaviors.ReadOnly] =
      AwsError.unwrapOptionField("behavior", behavior)
    def getDemographic: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.SegmentDemographics.ReadOnly
    ] = AwsError.unwrapOptionField("demographic", demographic)
    def getLocation
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.SegmentLocation.ReadOnly] =
      AwsError.unwrapOptionField("location", location)
    def getMetrics: ZIO[Any, AwsError, Map[
      __string,
      zio.aws.pinpoint.model.MetricDimension.ReadOnly
    ]] = AwsError.unwrapOptionField("metrics", metrics)
    def getUserAttributes: ZIO[Any, AwsError, Map[
      __string,
      zio.aws.pinpoint.model.AttributeDimension.ReadOnly
    ]] = AwsError.unwrapOptionField("userAttributes", userAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.SegmentDimensions
  ) extends zio.aws.pinpoint.model.SegmentDimensions.ReadOnly {
    override val attributes: Optional[
      Map[__string, zio.aws.pinpoint.model.AttributeDimension.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.attributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> zio.aws.pinpoint.model.AttributeDimension
              .wrap(value)
          })
          .toMap
      )
    override val behavior
        : Optional[zio.aws.pinpoint.model.SegmentBehaviors.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.behavior())
        .map(value => zio.aws.pinpoint.model.SegmentBehaviors.wrap(value))
    override val demographic
        : Optional[zio.aws.pinpoint.model.SegmentDemographics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.demographic())
        .map(value => zio.aws.pinpoint.model.SegmentDemographics.wrap(value))
    override val location
        : Optional[zio.aws.pinpoint.model.SegmentLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.location())
        .map(value => zio.aws.pinpoint.model.SegmentLocation.wrap(value))
    override val metrics: Optional[
      Map[__string, zio.aws.pinpoint.model.MetricDimension.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.metrics())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> zio.aws.pinpoint.model.MetricDimension
              .wrap(value)
          })
          .toMap
      )
    override val userAttributes: Optional[
      Map[__string, zio.aws.pinpoint.model.AttributeDimension.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.userAttributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> zio.aws.pinpoint.model.AttributeDimension
              .wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.SegmentDimensions
  ): zio.aws.pinpoint.model.SegmentDimensions.ReadOnly = new Wrapper(impl)
}
