package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SMSTemplateRequest(
    body: Optional[__string] = Optional.Absent,
    defaultSubstitutions: Optional[__string] = Optional.Absent,
    recommenderId: Optional[__string] = Optional.Absent,
    tags: Optional[Map[__string, __string]] = Optional.Absent,
    templateDescription: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.SMSTemplateRequest = {
    import SMSTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.SMSTemplateRequest
      .builder()
      .optionallyWith(body.map(value => value: java.lang.String))(_.body)
      .optionallyWith(
        defaultSubstitutions.map(value => value: java.lang.String)
      )(_.defaultSubstitutions)
      .optionallyWith(recommenderId.map(value => value: java.lang.String))(
        _.recommenderId
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        templateDescription.map(value => value: java.lang.String)
      )(_.templateDescription)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.SMSTemplateRequest.ReadOnly =
    zio.aws.pinpoint.model.SMSTemplateRequest.wrap(buildAwsValue())
}
object SMSTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.SMSTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.SMSTemplateRequest =
      zio.aws.pinpoint.model.SMSTemplateRequest(
        body.map(value => value),
        defaultSubstitutions.map(value => value),
        recommenderId.map(value => value),
        tags.map(value => value),
        templateDescription.map(value => value)
      )
    def body: Optional[__string]
    def defaultSubstitutions: Optional[__string]
    def recommenderId: Optional[__string]
    def tags: Optional[Map[__string, __string]]
    def templateDescription: Optional[__string]
    def getBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("body", body)
    def getDefaultSubstitutions: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("defaultSubstitutions", defaultSubstitutions)
    def getRecommenderId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("recommenderId", recommenderId)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTemplateDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateDescription", templateDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.SMSTemplateRequest
  ) extends zio.aws.pinpoint.model.SMSTemplateRequest.ReadOnly {
    override val body: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.body())
      .map(value => value: __string)
    override val defaultSubstitutions: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultSubstitutions())
        .map(value => value: __string)
    override val recommenderId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.recommenderId())
      .map(value => value: __string)
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val templateDescription: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.templateDescription())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.SMSTemplateRequest
  ): zio.aws.pinpoint.model.SMSTemplateRequest.ReadOnly = new Wrapper(impl)
}
