package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PushNotificationTemplateRequest(
    adm: Optional[zio.aws.pinpoint.model.AndroidPushNotificationTemplate] =
      Optional.Absent,
    apns: Optional[zio.aws.pinpoint.model.APNSPushNotificationTemplate] =
      Optional.Absent,
    baidu: Optional[zio.aws.pinpoint.model.AndroidPushNotificationTemplate] =
      Optional.Absent,
    defaultValue: Optional[
      zio.aws.pinpoint.model.DefaultPushNotificationTemplate
    ] = Optional.Absent,
    defaultSubstitutions: Optional[__string] = Optional.Absent,
    gcm: Optional[zio.aws.pinpoint.model.AndroidPushNotificationTemplate] =
      Optional.Absent,
    recommenderId: Optional[__string] = Optional.Absent,
    tags: Optional[Map[__string, __string]] = Optional.Absent,
    templateDescription: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.PushNotificationTemplateRequest = {
    import PushNotificationTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.PushNotificationTemplateRequest
      .builder()
      .optionallyWith(adm.map(value => value.buildAwsValue()))(_.adm)
      .optionallyWith(apns.map(value => value.buildAwsValue()))(_.apns)
      .optionallyWith(baidu.map(value => value.buildAwsValue()))(_.baidu)
      .optionallyWith(defaultValue.map(value => value.buildAwsValue()))(
        _.defaultValue
      )
      .optionallyWith(
        defaultSubstitutions.map(value => value: java.lang.String)
      )(_.defaultSubstitutions)
      .optionallyWith(gcm.map(value => value.buildAwsValue()))(_.gcm)
      .optionallyWith(recommenderId.map(value => value: java.lang.String))(
        _.recommenderId
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        templateDescription.map(value => value: java.lang.String)
      )(_.templateDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpoint.model.PushNotificationTemplateRequest.ReadOnly =
    zio.aws.pinpoint.model.PushNotificationTemplateRequest.wrap(buildAwsValue())
}
object PushNotificationTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.PushNotificationTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.PushNotificationTemplateRequest =
      zio.aws.pinpoint.model.PushNotificationTemplateRequest(
        adm.map(value => value.asEditable),
        apns.map(value => value.asEditable),
        baidu.map(value => value.asEditable),
        defaultValue.map(value => value.asEditable),
        defaultSubstitutions.map(value => value),
        gcm.map(value => value.asEditable),
        recommenderId.map(value => value),
        tags.map(value => value),
        templateDescription.map(value => value)
      )
    def adm: Optional[
      zio.aws.pinpoint.model.AndroidPushNotificationTemplate.ReadOnly
    ]
    def apns
        : Optional[zio.aws.pinpoint.model.APNSPushNotificationTemplate.ReadOnly]
    def baidu: Optional[
      zio.aws.pinpoint.model.AndroidPushNotificationTemplate.ReadOnly
    ]
    def defaultValue: Optional[
      zio.aws.pinpoint.model.DefaultPushNotificationTemplate.ReadOnly
    ]
    def defaultSubstitutions: Optional[__string]
    def gcm: Optional[
      zio.aws.pinpoint.model.AndroidPushNotificationTemplate.ReadOnly
    ]
    def recommenderId: Optional[__string]
    def tags: Optional[Map[__string, __string]]
    def templateDescription: Optional[__string]
    def getAdm: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.AndroidPushNotificationTemplate.ReadOnly
    ] = AwsError.unwrapOptionField("adm", adm)
    def getApns: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.APNSPushNotificationTemplate.ReadOnly
    ] = AwsError.unwrapOptionField("apns", apns)
    def getBaidu: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.AndroidPushNotificationTemplate.ReadOnly
    ] = AwsError.unwrapOptionField("baidu", baidu)
    def getDefaultValue: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.DefaultPushNotificationTemplate.ReadOnly
    ] = AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getDefaultSubstitutions: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("defaultSubstitutions", defaultSubstitutions)
    def getGcm: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.AndroidPushNotificationTemplate.ReadOnly
    ] = AwsError.unwrapOptionField("gcm", gcm)
    def getRecommenderId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("recommenderId", recommenderId)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTemplateDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateDescription", templateDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.PushNotificationTemplateRequest
  ) extends zio.aws.pinpoint.model.PushNotificationTemplateRequest.ReadOnly {
    override val adm: Optional[
      zio.aws.pinpoint.model.AndroidPushNotificationTemplate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.adm())
      .map(value =>
        zio.aws.pinpoint.model.AndroidPushNotificationTemplate.wrap(value)
      )
    override val apns: Optional[
      zio.aws.pinpoint.model.APNSPushNotificationTemplate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.apns())
      .map(value =>
        zio.aws.pinpoint.model.APNSPushNotificationTemplate.wrap(value)
      )
    override val baidu: Optional[
      zio.aws.pinpoint.model.AndroidPushNotificationTemplate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.baidu())
      .map(value =>
        zio.aws.pinpoint.model.AndroidPushNotificationTemplate.wrap(value)
      )
    override val defaultValue: Optional[
      zio.aws.pinpoint.model.DefaultPushNotificationTemplate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultValue())
      .map(value =>
        zio.aws.pinpoint.model.DefaultPushNotificationTemplate.wrap(value)
      )
    override val defaultSubstitutions: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultSubstitutions())
        .map(value => value: __string)
    override val gcm: Optional[
      zio.aws.pinpoint.model.AndroidPushNotificationTemplate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.gcm())
      .map(value =>
        zio.aws.pinpoint.model.AndroidPushNotificationTemplate.wrap(value)
      )
    override val recommenderId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.recommenderId())
      .map(value => value: __string)
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val templateDescription: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.templateDescription())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.PushNotificationTemplateRequest
  ): zio.aws.pinpoint.model.PushNotificationTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
