package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PushMessageActivity(
    messageConfig: Optional[zio.aws.pinpoint.model.JourneyPushMessage] =
      Optional.Absent,
    nextActivity: Optional[__string] = Optional.Absent,
    templateName: Optional[__string] = Optional.Absent,
    templateVersion: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.PushMessageActivity = {
    import PushMessageActivity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.PushMessageActivity
      .builder()
      .optionallyWith(messageConfig.map(value => value.buildAwsValue()))(
        _.messageConfig
      )
      .optionallyWith(nextActivity.map(value => value: java.lang.String))(
        _.nextActivity
      )
      .optionallyWith(templateName.map(value => value: java.lang.String))(
        _.templateName
      )
      .optionallyWith(templateVersion.map(value => value: java.lang.String))(
        _.templateVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.PushMessageActivity.ReadOnly =
    zio.aws.pinpoint.model.PushMessageActivity.wrap(buildAwsValue())
}
object PushMessageActivity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.PushMessageActivity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.PushMessageActivity =
      zio.aws.pinpoint.model.PushMessageActivity(
        messageConfig.map(value => value.asEditable),
        nextActivity.map(value => value),
        templateName.map(value => value),
        templateVersion.map(value => value)
      )
    def messageConfig
        : Optional[zio.aws.pinpoint.model.JourneyPushMessage.ReadOnly]
    def nextActivity: Optional[__string]
    def templateName: Optional[__string]
    def templateVersion: Optional[__string]
    def getMessageConfig: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.JourneyPushMessage.ReadOnly
    ] = AwsError.unwrapOptionField("messageConfig", messageConfig)
    def getNextActivity: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextActivity", nextActivity)
    def getTemplateName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getTemplateVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateVersion", templateVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.PushMessageActivity
  ) extends zio.aws.pinpoint.model.PushMessageActivity.ReadOnly {
    override val messageConfig
        : Optional[zio.aws.pinpoint.model.JourneyPushMessage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messageConfig())
        .map(value => zio.aws.pinpoint.model.JourneyPushMessage.wrap(value))
    override val nextActivity: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextActivity())
      .map(value => value: __string)
    override val templateName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.templateName())
      .map(value => value: __string)
    override val templateVersion: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.templateVersion())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.PushMessageActivity
  ): zio.aws.pinpoint.model.PushMessageActivity.ReadOnly = new Wrapper(impl)
}
