package zio.aws.pinpoint.model
import scala.jdk.CollectionConverters.*
sealed trait MessageType {
  def unwrap: software.amazon.awssdk.services.pinpoint.model.MessageType
}
object MessageType {
  def wrap(
      value: software.amazon.awssdk.services.pinpoint.model.MessageType
  ): zio.aws.pinpoint.model.MessageType = value match {
    case software.amazon.awssdk.services.pinpoint.model.MessageType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pinpoint.model.MessageType.TRANSACTIONAL =>
      val r = TRANSACTIONAL
      r
    case software.amazon.awssdk.services.pinpoint.model.MessageType.PROMOTIONAL =>
      val r = PROMOTIONAL
      r
  }
  case object unknownToSdkVersion extends zio.aws.pinpoint.model.MessageType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.MessageType =
      software.amazon.awssdk.services.pinpoint.model.MessageType.UNKNOWN_TO_SDK_VERSION
  }
  case object TRANSACTIONAL extends zio.aws.pinpoint.model.MessageType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.MessageType =
      software.amazon.awssdk.services.pinpoint.model.MessageType.TRANSACTIONAL
  }
  case object PROMOTIONAL extends zio.aws.pinpoint.model.MessageType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.MessageType =
      software.amazon.awssdk.services.pinpoint.model.MessageType.PROMOTIONAL
  }
}
