package zio.aws.pinpoint.model
import scala.jdk.CollectionConverters.*
sealed trait Layout {
  def unwrap: software.amazon.awssdk.services.pinpoint.model.Layout
}
object Layout {
  def wrap(
      value: software.amazon.awssdk.services.pinpoint.model.Layout
  ): zio.aws.pinpoint.model.Layout = value match {
    case software.amazon.awssdk.services.pinpoint.model.Layout.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pinpoint.model.Layout.BOTTOM_BANNER =>
      val r = BOTTOM_BANNER
      r
    case software.amazon.awssdk.services.pinpoint.model.Layout.TOP_BANNER =>
      val r = TOP_BANNER
      r
    case software.amazon.awssdk.services.pinpoint.model.Layout.OVERLAYS =>
      val r = OVERLAYS
      r
    case software.amazon.awssdk.services.pinpoint.model.Layout.MOBILE_FEED =>
      val r = MOBILE_FEED
      r
    case software.amazon.awssdk.services.pinpoint.model.Layout.MIDDLE_BANNER =>
      val r = MIDDLE_BANNER
      r
    case software.amazon.awssdk.services.pinpoint.model.Layout.CAROUSEL =>
      val r = CAROUSEL
      r
  }
  case object unknownToSdkVersion extends zio.aws.pinpoint.model.Layout {
    override def unwrap: software.amazon.awssdk.services.pinpoint.model.Layout =
      software.amazon.awssdk.services.pinpoint.model.Layout.UNKNOWN_TO_SDK_VERSION
  }
  case object BOTTOM_BANNER extends zio.aws.pinpoint.model.Layout {
    override def unwrap: software.amazon.awssdk.services.pinpoint.model.Layout =
      software.amazon.awssdk.services.pinpoint.model.Layout.BOTTOM_BANNER
  }
  case object TOP_BANNER extends zio.aws.pinpoint.model.Layout {
    override def unwrap: software.amazon.awssdk.services.pinpoint.model.Layout =
      software.amazon.awssdk.services.pinpoint.model.Layout.TOP_BANNER
  }
  case object OVERLAYS extends zio.aws.pinpoint.model.Layout {
    override def unwrap: software.amazon.awssdk.services.pinpoint.model.Layout =
      software.amazon.awssdk.services.pinpoint.model.Layout.OVERLAYS
  }
  case object MOBILE_FEED extends zio.aws.pinpoint.model.Layout {
    override def unwrap: software.amazon.awssdk.services.pinpoint.model.Layout =
      software.amazon.awssdk.services.pinpoint.model.Layout.MOBILE_FEED
  }
  case object MIDDLE_BANNER extends zio.aws.pinpoint.model.Layout {
    override def unwrap: software.amazon.awssdk.services.pinpoint.model.Layout =
      software.amazon.awssdk.services.pinpoint.model.Layout.MIDDLE_BANNER
  }
  case object CAROUSEL extends zio.aws.pinpoint.model.Layout {
    override def unwrap: software.amazon.awssdk.services.pinpoint.model.Layout =
      software.amazon.awssdk.services.pinpoint.model.Layout.CAROUSEL
  }
}
