package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class JourneyStateRequest(
    state: Optional[zio.aws.pinpoint.model.State] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.JourneyStateRequest = {
    import JourneyStateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.JourneyStateRequest
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.JourneyStateRequest.ReadOnly =
    zio.aws.pinpoint.model.JourneyStateRequest.wrap(buildAwsValue())
}
object JourneyStateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.JourneyStateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.JourneyStateRequest =
      zio.aws.pinpoint.model.JourneyStateRequest(state.map(value => value))
    def state: Optional[zio.aws.pinpoint.model.State]
    def getState: ZIO[Any, AwsError, zio.aws.pinpoint.model.State] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.JourneyStateRequest
  ) extends zio.aws.pinpoint.model.JourneyStateRequest.ReadOnly {
    override val state: Optional[zio.aws.pinpoint.model.State] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.pinpoint.model.State.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.JourneyStateRequest
  ): zio.aws.pinpoint.model.JourneyStateRequest.ReadOnly = new Wrapper(impl)
}
