package zio.aws.pinpoint.model
import zio.prelude.data.Optional
import zio.aws.pinpoint.model.primitives.{__string, __integer}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class JourneyLimits(
    dailyCap: Optional[__integer] = Optional.Absent,
    endpointReentryCap: Optional[__integer] = Optional.Absent,
    messagesPerSecond: Optional[__integer] = Optional.Absent,
    endpointReentryInterval: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.JourneyLimits = {
    import JourneyLimits.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.JourneyLimits
      .builder()
      .optionallyWith(dailyCap.map(value => value: Integer))(_.dailyCap)
      .optionallyWith(endpointReentryCap.map(value => value: Integer))(
        _.endpointReentryCap
      )
      .optionallyWith(messagesPerSecond.map(value => value: Integer))(
        _.messagesPerSecond
      )
      .optionallyWith(
        endpointReentryInterval.map(value => value: java.lang.String)
      )(_.endpointReentryInterval)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.JourneyLimits.ReadOnly =
    zio.aws.pinpoint.model.JourneyLimits.wrap(buildAwsValue())
}
object JourneyLimits {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.JourneyLimits
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.JourneyLimits =
      zio.aws.pinpoint.model.JourneyLimits(
        dailyCap.map(value => value),
        endpointReentryCap.map(value => value),
        messagesPerSecond.map(value => value),
        endpointReentryInterval.map(value => value)
      )
    def dailyCap: Optional[__integer]
    def endpointReentryCap: Optional[__integer]
    def messagesPerSecond: Optional[__integer]
    def endpointReentryInterval: Optional[__string]
    def getDailyCap: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("dailyCap", dailyCap)
    def getEndpointReentryCap: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("endpointReentryCap", endpointReentryCap)
    def getMessagesPerSecond: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("messagesPerSecond", messagesPerSecond)
    def getEndpointReentryInterval: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("endpointReentryInterval", endpointReentryInterval)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.JourneyLimits
  ) extends zio.aws.pinpoint.model.JourneyLimits.ReadOnly {
    override val dailyCap: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.dailyCap())
      .map(value => value: __integer)
    override val endpointReentryCap: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointReentryCap())
      .map(value => value: __integer)
    override val messagesPerSecond: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.messagesPerSecond())
      .map(value => value: __integer)
    override val endpointReentryInterval: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointReentryInterval())
        .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.JourneyLimits
  ): zio.aws.pinpoint.model.JourneyLimits.ReadOnly = new Wrapper(impl)
}
