package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class JourneyExecutionActivityMetricsResponse(
    activityType: __string,
    applicationId: __string,
    journeyActivityId: __string,
    journeyId: __string,
    lastEvaluatedTime: __string,
    metrics: Map[__string, __string]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.JourneyExecutionActivityMetricsResponse = {
    import JourneyExecutionActivityMetricsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.JourneyExecutionActivityMetricsResponse
      .builder()
      .activityType(activityType: java.lang.String)
      .applicationId(applicationId: java.lang.String)
      .journeyActivityId(journeyActivityId: java.lang.String)
      .journeyId(journeyId: java.lang.String)
      .lastEvaluatedTime(lastEvaluatedTime: java.lang.String)
      .metrics(
        metrics
          .map({ case (key, value) =>
            (key: java.lang.String) -> (value: java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly
      : zio.aws.pinpoint.model.JourneyExecutionActivityMetricsResponse.ReadOnly =
    zio.aws.pinpoint.model.JourneyExecutionActivityMetricsResponse
      .wrap(buildAwsValue())
}
object JourneyExecutionActivityMetricsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.JourneyExecutionActivityMetricsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpoint.model.JourneyExecutionActivityMetricsResponse =
      zio.aws.pinpoint.model.JourneyExecutionActivityMetricsResponse(
        activityType,
        applicationId,
        journeyActivityId,
        journeyId,
        lastEvaluatedTime,
        metrics
      )
    def activityType: __string
    def applicationId: __string
    def journeyActivityId: __string
    def journeyId: __string
    def lastEvaluatedTime: __string
    def metrics: Map[__string, __string]
    def getActivityType: ZIO[Any, Nothing, __string] = ZIO.succeed(activityType)
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getJourneyActivityId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(journeyActivityId)
    def getJourneyId: ZIO[Any, Nothing, __string] = ZIO.succeed(journeyId)
    def getLastEvaluatedTime: ZIO[Any, Nothing, __string] =
      ZIO.succeed(lastEvaluatedTime)
    def getMetrics: ZIO[Any, Nothing, Map[__string, __string]] =
      ZIO.succeed(metrics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.JourneyExecutionActivityMetricsResponse
  ) extends zio.aws.pinpoint.model.JourneyExecutionActivityMetricsResponse.ReadOnly {
    override val activityType: __string = impl.activityType(): __string
    override val applicationId: __string = impl.applicationId(): __string
    override val journeyActivityId: __string =
      impl.journeyActivityId(): __string
    override val journeyId: __string = impl.journeyId(): __string
    override val lastEvaluatedTime: __string =
      impl.lastEvaluatedTime(): __string
    override val metrics: Map[__string, __string] = impl
      .metrics()
      .asScala
      .map({ case (key, value) =>
        (key: __string) -> (value: __string)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.JourneyExecutionActivityMetricsResponse
  ): zio.aws.pinpoint.model.JourneyExecutionActivityMetricsResponse.ReadOnly =
    new Wrapper(impl)
}
