package zio.aws.pinpoint.model
import scala.jdk.CollectionConverters.*
sealed trait JobStatus {
  def unwrap: software.amazon.awssdk.services.pinpoint.model.JobStatus
}
object JobStatus {
  def wrap(
      value: software.amazon.awssdk.services.pinpoint.model.JobStatus
  ): zio.aws.pinpoint.model.JobStatus = value match {
    case software.amazon.awssdk.services.pinpoint.model.JobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pinpoint.model.JobStatus.CREATED =>
      val r = CREATED
      r
    case software.amazon.awssdk.services.pinpoint.model.JobStatus.PREPARING_FOR_INITIALIZATION =>
      val r = PREPARING_FOR_INITIALIZATION
      r
    case software.amazon.awssdk.services.pinpoint.model.JobStatus.INITIALIZING =>
      val r = INITIALIZING
      r
    case software.amazon.awssdk.services.pinpoint.model.JobStatus.PROCESSING =>
      val r = PROCESSING
      r
    case software.amazon.awssdk.services.pinpoint.model.JobStatus.PENDING_JOB =>
      val r = PENDING_JOB
      r
    case software.amazon.awssdk.services.pinpoint.model.JobStatus.COMPLETING =>
      val r = COMPLETING
      r
    case software.amazon.awssdk.services.pinpoint.model.JobStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.pinpoint.model.JobStatus.FAILING =>
      val r = FAILING
      r
    case software.amazon.awssdk.services.pinpoint.model.JobStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.pinpoint.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.JobStatus =
      software.amazon.awssdk.services.pinpoint.model.JobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATED extends zio.aws.pinpoint.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.JobStatus =
      software.amazon.awssdk.services.pinpoint.model.JobStatus.CREATED
  }
  case object PREPARING_FOR_INITIALIZATION
      extends zio.aws.pinpoint.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.JobStatus =
      software.amazon.awssdk.services.pinpoint.model.JobStatus.PREPARING_FOR_INITIALIZATION
  }
  case object INITIALIZING extends zio.aws.pinpoint.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.JobStatus =
      software.amazon.awssdk.services.pinpoint.model.JobStatus.INITIALIZING
  }
  case object PROCESSING extends zio.aws.pinpoint.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.JobStatus =
      software.amazon.awssdk.services.pinpoint.model.JobStatus.PROCESSING
  }
  case object PENDING_JOB extends zio.aws.pinpoint.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.JobStatus =
      software.amazon.awssdk.services.pinpoint.model.JobStatus.PENDING_JOB
  }
  case object COMPLETING extends zio.aws.pinpoint.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.JobStatus =
      software.amazon.awssdk.services.pinpoint.model.JobStatus.COMPLETING
  }
  case object COMPLETED extends zio.aws.pinpoint.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.JobStatus =
      software.amazon.awssdk.services.pinpoint.model.JobStatus.COMPLETED
  }
  case object FAILING extends zio.aws.pinpoint.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.JobStatus =
      software.amazon.awssdk.services.pinpoint.model.JobStatus.FAILING
  }
  case object FAILED extends zio.aws.pinpoint.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.JobStatus =
      software.amazon.awssdk.services.pinpoint.model.JobStatus.FAILED
  }
}
