package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ItemResponse(
    endpointItemResponse: Optional[
      zio.aws.pinpoint.model.EndpointItemResponse
    ] = Optional.Absent,
    eventsItemResponse: Optional[
      Map[__string, zio.aws.pinpoint.model.EventItemResponse]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.ItemResponse = {
    import ItemResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.ItemResponse
      .builder()
      .optionallyWith(endpointItemResponse.map(value => value.buildAwsValue()))(
        _.endpointItemResponse
      )
      .optionallyWith(
        eventsItemResponse.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.eventsItemResponse)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.ItemResponse.ReadOnly =
    zio.aws.pinpoint.model.ItemResponse.wrap(buildAwsValue())
}
object ItemResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.ItemResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.ItemResponse =
      zio.aws.pinpoint.model.ItemResponse(
        endpointItemResponse.map(value => value.asEditable),
        eventsItemResponse.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def endpointItemResponse
        : Optional[zio.aws.pinpoint.model.EndpointItemResponse.ReadOnly]
    def eventsItemResponse: Optional[
      Map[__string, zio.aws.pinpoint.model.EventItemResponse.ReadOnly]
    ]
    def getEndpointItemResponse: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.EndpointItemResponse.ReadOnly
    ] = AwsError.unwrapOptionField("endpointItemResponse", endpointItemResponse)
    def getEventsItemResponse: ZIO[Any, AwsError, Map[
      __string,
      zio.aws.pinpoint.model.EventItemResponse.ReadOnly
    ]] = AwsError.unwrapOptionField("eventsItemResponse", eventsItemResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.ItemResponse
  ) extends zio.aws.pinpoint.model.ItemResponse.ReadOnly {
    override val endpointItemResponse
        : Optional[zio.aws.pinpoint.model.EndpointItemResponse.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointItemResponse())
        .map(value => zio.aws.pinpoint.model.EndpointItemResponse.wrap(value))
    override val eventsItemResponse: Optional[
      Map[__string, zio.aws.pinpoint.model.EventItemResponse.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.eventsItemResponse())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> zio.aws.pinpoint.model.EventItemResponse
              .wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.ItemResponse
  ): zio.aws.pinpoint.model.ItemResponse.ReadOnly = new Wrapper(impl)
}
