package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class InAppTemplateRequest(
    content: Optional[Iterable[zio.aws.pinpoint.model.InAppMessageContent]] =
      Optional.Absent,
    customConfig: Optional[Map[__string, __string]] = Optional.Absent,
    layout: Optional[zio.aws.pinpoint.model.Layout] = Optional.Absent,
    tags: Optional[Map[__string, __string]] = Optional.Absent,
    templateDescription: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.InAppTemplateRequest = {
    import InAppTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.InAppTemplateRequest
      .builder()
      .optionallyWith(
        content.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.content)
      .optionallyWith(
        customConfig.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.customConfig)
      .optionallyWith(layout.map(value => value.unwrap))(_.layout)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        templateDescription.map(value => value: java.lang.String)
      )(_.templateDescription)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.InAppTemplateRequest.ReadOnly =
    zio.aws.pinpoint.model.InAppTemplateRequest.wrap(buildAwsValue())
}
object InAppTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.InAppTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.InAppTemplateRequest =
      zio.aws.pinpoint.model.InAppTemplateRequest(
        content.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        customConfig.map(value => value),
        layout.map(value => value),
        tags.map(value => value),
        templateDescription.map(value => value)
      )
    def content
        : Optional[List[zio.aws.pinpoint.model.InAppMessageContent.ReadOnly]]
    def customConfig: Optional[Map[__string, __string]]
    def layout: Optional[zio.aws.pinpoint.model.Layout]
    def tags: Optional[Map[__string, __string]]
    def templateDescription: Optional[__string]
    def getContent: ZIO[Any, AwsError, List[
      zio.aws.pinpoint.model.InAppMessageContent.ReadOnly
    ]] = AwsError.unwrapOptionField("content", content)
    def getCustomConfig: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("customConfig", customConfig)
    def getLayout: ZIO[Any, AwsError, zio.aws.pinpoint.model.Layout] =
      AwsError.unwrapOptionField("layout", layout)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTemplateDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateDescription", templateDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.InAppTemplateRequest
  ) extends zio.aws.pinpoint.model.InAppTemplateRequest.ReadOnly {
    override val content
        : Optional[List[zio.aws.pinpoint.model.InAppMessageContent.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.content())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpoint.model.InAppMessageContent.wrap(item)
          }.toList
        )
    override val customConfig: Optional[Map[__string, __string]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customConfig())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> (value: __string)
            })
            .toMap
        )
    override val layout: Optional[zio.aws.pinpoint.model.Layout] =
      zio.aws.core.internal
        .optionalFromNullable(impl.layout())
        .map(value => zio.aws.pinpoint.model.Layout.wrap(value))
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val templateDescription: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.templateDescription())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.InAppTemplateRequest
  ): zio.aws.pinpoint.model.InAppTemplateRequest.ReadOnly = new Wrapper(impl)
}
