package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class InAppMessageButton(
    android: Optional[zio.aws.pinpoint.model.OverrideButtonConfiguration] =
      Optional.Absent,
    defaultConfig: Optional[zio.aws.pinpoint.model.DefaultButtonConfiguration] =
      Optional.Absent,
    ios: Optional[zio.aws.pinpoint.model.OverrideButtonConfiguration] =
      Optional.Absent,
    web: Optional[zio.aws.pinpoint.model.OverrideButtonConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.InAppMessageButton = {
    import InAppMessageButton.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.InAppMessageButton
      .builder()
      .optionallyWith(android.map(value => value.buildAwsValue()))(_.android)
      .optionallyWith(defaultConfig.map(value => value.buildAwsValue()))(
        _.defaultConfig
      )
      .optionallyWith(ios.map(value => value.buildAwsValue()))(_.ios)
      .optionallyWith(web.map(value => value.buildAwsValue()))(_.web)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.InAppMessageButton.ReadOnly =
    zio.aws.pinpoint.model.InAppMessageButton.wrap(buildAwsValue())
}
object InAppMessageButton {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.InAppMessageButton
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.InAppMessageButton =
      zio.aws.pinpoint.model.InAppMessageButton(
        android.map(value => value.asEditable),
        defaultConfig.map(value => value.asEditable),
        ios.map(value => value.asEditable),
        web.map(value => value.asEditable)
      )
    def android
        : Optional[zio.aws.pinpoint.model.OverrideButtonConfiguration.ReadOnly]
    def defaultConfig
        : Optional[zio.aws.pinpoint.model.DefaultButtonConfiguration.ReadOnly]
    def ios
        : Optional[zio.aws.pinpoint.model.OverrideButtonConfiguration.ReadOnly]
    def web
        : Optional[zio.aws.pinpoint.model.OverrideButtonConfiguration.ReadOnly]
    def getAndroid: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.OverrideButtonConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("android", android)
    def getDefaultConfig: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.DefaultButtonConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("defaultConfig", defaultConfig)
    def getIos: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.OverrideButtonConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("ios", ios)
    def getWeb: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.OverrideButtonConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("web", web)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.InAppMessageButton
  ) extends zio.aws.pinpoint.model.InAppMessageButton.ReadOnly {
    override val android: Optional[
      zio.aws.pinpoint.model.OverrideButtonConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.android())
      .map(value =>
        zio.aws.pinpoint.model.OverrideButtonConfiguration.wrap(value)
      )
    override val defaultConfig
        : Optional[zio.aws.pinpoint.model.DefaultButtonConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultConfig())
        .map(value =>
          zio.aws.pinpoint.model.DefaultButtonConfiguration.wrap(value)
        )
    override val ios: Optional[
      zio.aws.pinpoint.model.OverrideButtonConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ios())
      .map(value =>
        zio.aws.pinpoint.model.OverrideButtonConfiguration.wrap(value)
      )
    override val web: Optional[
      zio.aws.pinpoint.model.OverrideButtonConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.web())
      .map(value =>
        zio.aws.pinpoint.model.OverrideButtonConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.InAppMessageButton
  ): zio.aws.pinpoint.model.InAppMessageButton.ReadOnly = new Wrapper(impl)
}
