package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetSegmentVersionsRequest(
    applicationId: __string,
    pageSize: Optional[__string] = Optional.Absent,
    segmentId: __string,
    token: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionsRequest = {
    import GetSegmentVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionsRequest
      .builder()
      .applicationId(applicationId: java.lang.String)
      .optionallyWith(pageSize.map(value => value: java.lang.String))(
        _.pageSize
      )
      .segmentId(segmentId: java.lang.String)
      .optionallyWith(token.map(value => value: java.lang.String))(_.token)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.GetSegmentVersionsRequest.ReadOnly =
    zio.aws.pinpoint.model.GetSegmentVersionsRequest.wrap(buildAwsValue())
}
object GetSegmentVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.GetSegmentVersionsRequest =
      zio.aws.pinpoint.model.GetSegmentVersionsRequest(
        applicationId,
        pageSize.map(value => value),
        segmentId,
        token.map(value => value)
      )
    def applicationId: __string
    def pageSize: Optional[__string]
    def segmentId: __string
    def token: Optional[__string]
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getPageSize: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getSegmentId: ZIO[Any, Nothing, __string] = ZIO.succeed(segmentId)
    def getToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("token", token)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionsRequest
  ) extends zio.aws.pinpoint.model.GetSegmentVersionsRequest.ReadOnly {
    override val applicationId: __string = impl.applicationId(): __string
    override val pageSize: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value => value: __string)
    override val segmentId: __string = impl.segmentId(): __string
    override val token: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.token())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionsRequest
  ): zio.aws.pinpoint.model.GetSegmentVersionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
