package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetRecommenderConfigurationsRequest(
    pageSize: Optional[__string] = Optional.Absent,
    token: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.GetRecommenderConfigurationsRequest = {
    import GetRecommenderConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.GetRecommenderConfigurationsRequest
      .builder()
      .optionallyWith(pageSize.map(value => value: java.lang.String))(
        _.pageSize
      )
      .optionallyWith(token.map(value => value: java.lang.String))(_.token)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpoint.model.GetRecommenderConfigurationsRequest.ReadOnly =
    zio.aws.pinpoint.model.GetRecommenderConfigurationsRequest
      .wrap(buildAwsValue())
}
object GetRecommenderConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.GetRecommenderConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.GetRecommenderConfigurationsRequest =
      zio.aws.pinpoint.model.GetRecommenderConfigurationsRequest(
        pageSize.map(value => value),
        token.map(value => value)
      )
    def pageSize: Optional[__string]
    def token: Optional[__string]
    def getPageSize: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("token", token)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.GetRecommenderConfigurationsRequest
  ) extends zio.aws.pinpoint.model.GetRecommenderConfigurationsRequest.ReadOnly {
    override val pageSize: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value => value: __string)
    override val token: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.token())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.GetRecommenderConfigurationsRequest
  ): zio.aws.pinpoint.model.GetRecommenderConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
