package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetEndpointResponse(
    endpointResponse: zio.aws.pinpoint.model.EndpointResponse
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.GetEndpointResponse = {
    import GetEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.GetEndpointResponse
      .builder()
      .endpointResponse(endpointResponse.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.GetEndpointResponse.ReadOnly =
    zio.aws.pinpoint.model.GetEndpointResponse.wrap(buildAwsValue())
}
object GetEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.GetEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.GetEndpointResponse =
      zio.aws.pinpoint.model.GetEndpointResponse(endpointResponse.asEditable)
    def endpointResponse: zio.aws.pinpoint.model.EndpointResponse.ReadOnly
    def getEndpointResponse
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.EndpointResponse.ReadOnly] =
      ZIO.succeed(endpointResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.GetEndpointResponse
  ) extends zio.aws.pinpoint.model.GetEndpointResponse.ReadOnly {
    override val endpointResponse
        : zio.aws.pinpoint.model.EndpointResponse.ReadOnly =
      zio.aws.pinpoint.model.EndpointResponse.wrap(impl.endpointResponse())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.GetEndpointResponse
  ): zio.aws.pinpoint.model.GetEndpointResponse.ReadOnly = new Wrapper(impl)
}
