package zio.aws.pinpoint.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.pinpoint.model.primitives.{__timestampIso8601, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class GetCampaignDateRangeKpiRequest(
    applicationId: __string,
    campaignId: __string,
    endTime: Optional[__timestampIso8601] = Optional.Absent,
    kpiName: __string,
    nextToken: Optional[__string] = Optional.Absent,
    pageSize: Optional[__string] = Optional.Absent,
    startTime: Optional[__timestampIso8601] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.GetCampaignDateRangeKpiRequest = {
    import GetCampaignDateRangeKpiRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.GetCampaignDateRangeKpiRequest
      .builder()
      .applicationId(applicationId: java.lang.String)
      .campaignId(campaignId: java.lang.String)
      .optionallyWith(endTime.map(value => value: Instant))(_.endTime)
      .kpiName(kpiName: java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(pageSize.map(value => value: java.lang.String))(
        _.pageSize
      )
      .optionallyWith(startTime.map(value => value: Instant))(_.startTime)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpoint.model.GetCampaignDateRangeKpiRequest.ReadOnly =
    zio.aws.pinpoint.model.GetCampaignDateRangeKpiRequest.wrap(buildAwsValue())
}
object GetCampaignDateRangeKpiRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.GetCampaignDateRangeKpiRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.GetCampaignDateRangeKpiRequest =
      zio.aws.pinpoint.model.GetCampaignDateRangeKpiRequest(
        applicationId,
        campaignId,
        endTime.map(value => value),
        kpiName,
        nextToken.map(value => value),
        pageSize.map(value => value),
        startTime.map(value => value)
      )
    def applicationId: __string
    def campaignId: __string
    def endTime: Optional[__timestampIso8601]
    def kpiName: __string
    def nextToken: Optional[__string]
    def pageSize: Optional[__string]
    def startTime: Optional[__timestampIso8601]
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getCampaignId: ZIO[Any, Nothing, __string] = ZIO.succeed(campaignId)
    def getEndTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getKpiName: ZIO[Any, Nothing, __string] = ZIO.succeed(kpiName)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPageSize: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getStartTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("startTime", startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.GetCampaignDateRangeKpiRequest
  ) extends zio.aws.pinpoint.model.GetCampaignDateRangeKpiRequest.ReadOnly {
    override val applicationId: __string = impl.applicationId(): __string
    override val campaignId: __string = impl.campaignId(): __string
    override val endTime: Optional[__timestampIso8601] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => value: __timestampIso8601)
    override val kpiName: __string = impl.kpiName(): __string
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
    override val pageSize: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value => value: __string)
    override val startTime: Optional[__timestampIso8601] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => value: __timestampIso8601)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.GetCampaignDateRangeKpiRequest
  ): zio.aws.pinpoint.model.GetCampaignDateRangeKpiRequest.ReadOnly =
    new Wrapper(impl)
}
