package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetApplicationSettingsResponse(
    applicationSettingsResource: zio.aws.pinpoint.model.ApplicationSettingsResource
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.GetApplicationSettingsResponse = {
    import GetApplicationSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.GetApplicationSettingsResponse
      .builder()
      .applicationSettingsResource(applicationSettingsResource.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.pinpoint.model.GetApplicationSettingsResponse.ReadOnly =
    zio.aws.pinpoint.model.GetApplicationSettingsResponse.wrap(buildAwsValue())
}
object GetApplicationSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.GetApplicationSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.GetApplicationSettingsResponse =
      zio.aws.pinpoint.model
        .GetApplicationSettingsResponse(applicationSettingsResource.asEditable)
    def applicationSettingsResource
        : zio.aws.pinpoint.model.ApplicationSettingsResource.ReadOnly
    def getApplicationSettingsResource: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.ApplicationSettingsResource.ReadOnly
    ] = ZIO.succeed(applicationSettingsResource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.GetApplicationSettingsResponse
  ) extends zio.aws.pinpoint.model.GetApplicationSettingsResponse.ReadOnly {
    override val applicationSettingsResource
        : zio.aws.pinpoint.model.ApplicationSettingsResource.ReadOnly =
      zio.aws.pinpoint.model.ApplicationSettingsResource
        .wrap(impl.applicationSettingsResource())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.GetApplicationSettingsResponse
  ): zio.aws.pinpoint.model.GetApplicationSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
