package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__boolean, __string}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GCMChannelRequest(
    apiKey: __string,
    enabled: Optional[__boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.GCMChannelRequest = {
    import GCMChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.GCMChannelRequest
      .builder()
      .apiKey(apiKey: java.lang.String)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.GCMChannelRequest.ReadOnly =
    zio.aws.pinpoint.model.GCMChannelRequest.wrap(buildAwsValue())
}
object GCMChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.GCMChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.GCMChannelRequest =
      zio.aws.pinpoint.model
        .GCMChannelRequest(apiKey, enabled.map(value => value))
    def apiKey: __string
    def enabled: Optional[__boolean]
    def getApiKey: ZIO[Any, Nothing, __string] = ZIO.succeed(apiKey)
    def getEnabled: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.GCMChannelRequest
  ) extends zio.aws.pinpoint.model.GCMChannelRequest.ReadOnly {
    override val apiKey: __string = impl.apiKey(): __string
    override val enabled: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: __boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.GCMChannelRequest
  ): zio.aws.pinpoint.model.GCMChannelRequest.ReadOnly = new Wrapper(impl)
}
