package zio.aws.pinpoint.model
import zio.prelude.data.Optional
import zio.aws.pinpoint.model.primitives.{__integer, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ExportJobResource(
    roleArn: __string,
    s3UrlPrefix: __string,
    segmentId: Optional[__string] = Optional.Absent,
    segmentVersion: Optional[__integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.ExportJobResource = {
    import ExportJobResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.ExportJobResource
      .builder()
      .roleArn(roleArn: java.lang.String)
      .s3UrlPrefix(s3UrlPrefix: java.lang.String)
      .optionallyWith(segmentId.map(value => value: java.lang.String))(
        _.segmentId
      )
      .optionallyWith(segmentVersion.map(value => value: Integer))(
        _.segmentVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.ExportJobResource.ReadOnly =
    zio.aws.pinpoint.model.ExportJobResource.wrap(buildAwsValue())
}
object ExportJobResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.ExportJobResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.ExportJobResource =
      zio.aws.pinpoint.model.ExportJobResource(
        roleArn,
        s3UrlPrefix,
        segmentId.map(value => value),
        segmentVersion.map(value => value)
      )
    def roleArn: __string
    def s3UrlPrefix: __string
    def segmentId: Optional[__string]
    def segmentVersion: Optional[__integer]
    def getRoleArn: ZIO[Any, Nothing, __string] = ZIO.succeed(roleArn)
    def getS3UrlPrefix: ZIO[Any, Nothing, __string] = ZIO.succeed(s3UrlPrefix)
    def getSegmentId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("segmentId", segmentId)
    def getSegmentVersion: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("segmentVersion", segmentVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.ExportJobResource
  ) extends zio.aws.pinpoint.model.ExportJobResource.ReadOnly {
    override val roleArn: __string = impl.roleArn(): __string
    override val s3UrlPrefix: __string = impl.s3UrlPrefix(): __string
    override val segmentId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.segmentId())
      .map(value => value: __string)
    override val segmentVersion: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.segmentVersion())
      .map(value => value: __integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.ExportJobResource
  ): zio.aws.pinpoint.model.ExportJobResource.ReadOnly = new Wrapper(impl)
}
