package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class EventFilter(
    dimensions: zio.aws.pinpoint.model.EventDimensions,
    filterType: zio.aws.pinpoint.model.FilterType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.EventFilter = {
    import EventFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.EventFilter
      .builder()
      .dimensions(dimensions.buildAwsValue())
      .filterType(filterType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.EventFilter.ReadOnly =
    zio.aws.pinpoint.model.EventFilter.wrap(buildAwsValue())
}
object EventFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.EventFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.EventFilter =
      zio.aws.pinpoint.model.EventFilter(dimensions.asEditable, filterType)
    def dimensions: zio.aws.pinpoint.model.EventDimensions.ReadOnly
    def filterType: zio.aws.pinpoint.model.FilterType
    def getDimensions
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.EventDimensions.ReadOnly] =
      ZIO.succeed(dimensions)
    def getFilterType: ZIO[Any, Nothing, zio.aws.pinpoint.model.FilterType] =
      ZIO.succeed(filterType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.EventFilter
  ) extends zio.aws.pinpoint.model.EventFilter.ReadOnly {
    override val dimensions: zio.aws.pinpoint.model.EventDimensions.ReadOnly =
      zio.aws.pinpoint.model.EventDimensions.wrap(impl.dimensions())
    override val filterType: zio.aws.pinpoint.model.FilterType =
      zio.aws.pinpoint.model.FilterType.wrap(impl.filterType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.EventFilter
  ): zio.aws.pinpoint.model.EventFilter.ReadOnly = new Wrapper(impl)
}
