package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EndpointUser(
    userAttributes: Optional[Map[__string, Iterable[__string]]] =
      Optional.Absent,
    userId: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.EndpointUser = {
    import EndpointUser.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.EndpointUser
      .builder()
      .optionallyWith(
        userAttributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.map { item =>
                item: java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.userAttributes)
      .optionallyWith(userId.map(value => value: java.lang.String))(_.userId)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.EndpointUser.ReadOnly =
    zio.aws.pinpoint.model.EndpointUser.wrap(buildAwsValue())
}
object EndpointUser {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.EndpointUser
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.EndpointUser =
      zio.aws.pinpoint.model.EndpointUser(
        userAttributes.map(value => value),
        userId.map(value => value)
      )
    def userAttributes: Optional[Map[__string, List[__string]]]
    def userId: Optional[__string]
    def getUserAttributes: ZIO[Any, AwsError, Map[__string, List[__string]]] =
      AwsError.unwrapOptionField("userAttributes", userAttributes)
    def getUserId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("userId", userId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.EndpointUser
  ) extends zio.aws.pinpoint.model.EndpointUser.ReadOnly {
    override val userAttributes: Optional[Map[__string, List[__string]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userAttributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> value.asScala.map { item =>
                item: __string
              }.toList
            })
            .toMap
        )
    override val userId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.EndpointUser
  ): zio.aws.pinpoint.model.EndpointUser.ReadOnly = new Wrapper(impl)
}
