package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class EndpointBatchRequest(
    item: Iterable[zio.aws.pinpoint.model.EndpointBatchItem]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.EndpointBatchRequest = {
    import EndpointBatchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.EndpointBatchRequest
      .builder()
      .item(item.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.EndpointBatchRequest.ReadOnly =
    zio.aws.pinpoint.model.EndpointBatchRequest.wrap(buildAwsValue())
}
object EndpointBatchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.EndpointBatchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.EndpointBatchRequest =
      zio.aws.pinpoint.model.EndpointBatchRequest(item.map { item =>
        item.asEditable
      })
    def item: List[zio.aws.pinpoint.model.EndpointBatchItem.ReadOnly]
    def getItem: ZIO[Any, Nothing, List[
      zio.aws.pinpoint.model.EndpointBatchItem.ReadOnly
    ]] = ZIO.succeed(item)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.EndpointBatchRequest
  ) extends zio.aws.pinpoint.model.EndpointBatchRequest.ReadOnly {
    override val item: List[zio.aws.pinpoint.model.EndpointBatchItem.ReadOnly] =
      impl
        .item()
        .asScala
        .map { item =>
          zio.aws.pinpoint.model.EndpointBatchItem.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.EndpointBatchRequest
  ): zio.aws.pinpoint.model.EndpointBatchRequest.ReadOnly = new Wrapper(impl)
}
