package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EmailTemplateRequest(
    defaultSubstitutions: Optional[__string] = Optional.Absent,
    htmlPart: Optional[__string] = Optional.Absent,
    recommenderId: Optional[__string] = Optional.Absent,
    subject: Optional[__string] = Optional.Absent,
    tags: Optional[Map[__string, __string]] = Optional.Absent,
    templateDescription: Optional[__string] = Optional.Absent,
    textPart: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.EmailTemplateRequest = {
    import EmailTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.EmailTemplateRequest
      .builder()
      .optionallyWith(
        defaultSubstitutions.map(value => value: java.lang.String)
      )(_.defaultSubstitutions)
      .optionallyWith(htmlPart.map(value => value: java.lang.String))(
        _.htmlPart
      )
      .optionallyWith(recommenderId.map(value => value: java.lang.String))(
        _.recommenderId
      )
      .optionallyWith(subject.map(value => value: java.lang.String))(_.subject)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        templateDescription.map(value => value: java.lang.String)
      )(_.templateDescription)
      .optionallyWith(textPart.map(value => value: java.lang.String))(
        _.textPart
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.EmailTemplateRequest.ReadOnly =
    zio.aws.pinpoint.model.EmailTemplateRequest.wrap(buildAwsValue())
}
object EmailTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.EmailTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.EmailTemplateRequest =
      zio.aws.pinpoint.model.EmailTemplateRequest(
        defaultSubstitutions.map(value => value),
        htmlPart.map(value => value),
        recommenderId.map(value => value),
        subject.map(value => value),
        tags.map(value => value),
        templateDescription.map(value => value),
        textPart.map(value => value)
      )
    def defaultSubstitutions: Optional[__string]
    def htmlPart: Optional[__string]
    def recommenderId: Optional[__string]
    def subject: Optional[__string]
    def tags: Optional[Map[__string, __string]]
    def templateDescription: Optional[__string]
    def textPart: Optional[__string]
    def getDefaultSubstitutions: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("defaultSubstitutions", defaultSubstitutions)
    def getHtmlPart: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("htmlPart", htmlPart)
    def getRecommenderId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("recommenderId", recommenderId)
    def getSubject: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("subject", subject)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTemplateDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateDescription", templateDescription)
    def getTextPart: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("textPart", textPart)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.EmailTemplateRequest
  ) extends zio.aws.pinpoint.model.EmailTemplateRequest.ReadOnly {
    override val defaultSubstitutions: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultSubstitutions())
        .map(value => value: __string)
    override val htmlPart: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.htmlPart())
      .map(value => value: __string)
    override val recommenderId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.recommenderId())
      .map(value => value: __string)
    override val subject: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.subject())
      .map(value => value: __string)
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val templateDescription: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.templateDescription())
      .map(value => value: __string)
    override val textPart: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.textPart())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.EmailTemplateRequest
  ): zio.aws.pinpoint.model.EmailTemplateRequest.ReadOnly = new Wrapper(impl)
}
