package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteSmsTemplateResponse(
    messageBody: zio.aws.pinpoint.model.MessageBody
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.DeleteSmsTemplateResponse = {
    import DeleteSmsTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.DeleteSmsTemplateResponse
      .builder()
      .messageBody(messageBody.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.DeleteSmsTemplateResponse.ReadOnly =
    zio.aws.pinpoint.model.DeleteSmsTemplateResponse.wrap(buildAwsValue())
}
object DeleteSmsTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.DeleteSmsTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.DeleteSmsTemplateResponse =
      zio.aws.pinpoint.model.DeleteSmsTemplateResponse(messageBody.asEditable)
    def messageBody: zio.aws.pinpoint.model.MessageBody.ReadOnly
    def getMessageBody
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.MessageBody.ReadOnly] =
      ZIO.succeed(messageBody)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.DeleteSmsTemplateResponse
  ) extends zio.aws.pinpoint.model.DeleteSmsTemplateResponse.ReadOnly {
    override val messageBody: zio.aws.pinpoint.model.MessageBody.ReadOnly =
      zio.aws.pinpoint.model.MessageBody.wrap(impl.messageBody())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.DeleteSmsTemplateResponse
  ): zio.aws.pinpoint.model.DeleteSmsTemplateResponse.ReadOnly = new Wrapper(
    impl
  )
}
