package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteAppResponse(
    applicationResponse: zio.aws.pinpoint.model.ApplicationResponse
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.DeleteAppResponse = {
    import DeleteAppResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.DeleteAppResponse
      .builder()
      .applicationResponse(applicationResponse.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.DeleteAppResponse.ReadOnly =
    zio.aws.pinpoint.model.DeleteAppResponse.wrap(buildAwsValue())
}
object DeleteAppResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.DeleteAppResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.DeleteAppResponse =
      zio.aws.pinpoint.model.DeleteAppResponse(applicationResponse.asEditable)
    def applicationResponse: zio.aws.pinpoint.model.ApplicationResponse.ReadOnly
    def getApplicationResponse: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.ApplicationResponse.ReadOnly
    ] = ZIO.succeed(applicationResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.DeleteAppResponse
  ) extends zio.aws.pinpoint.model.DeleteAppResponse.ReadOnly {
    override val applicationResponse
        : zio.aws.pinpoint.model.ApplicationResponse.ReadOnly =
      zio.aws.pinpoint.model.ApplicationResponse
        .wrap(impl.applicationResponse())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.DeleteAppResponse
  ): zio.aws.pinpoint.model.DeleteAppResponse.ReadOnly = new Wrapper(impl)
}
