package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DefaultPushNotificationTemplate(
    action: Optional[zio.aws.pinpoint.model.Action] = Optional.Absent,
    body: Optional[__string] = Optional.Absent,
    sound: Optional[__string] = Optional.Absent,
    title: Optional[__string] = Optional.Absent,
    url: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.DefaultPushNotificationTemplate = {
    import DefaultPushNotificationTemplate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.DefaultPushNotificationTemplate
      .builder()
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .optionallyWith(body.map(value => value: java.lang.String))(_.body)
      .optionallyWith(sound.map(value => value: java.lang.String))(_.sound)
      .optionallyWith(title.map(value => value: java.lang.String))(_.title)
      .optionallyWith(url.map(value => value: java.lang.String))(_.url)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpoint.model.DefaultPushNotificationTemplate.ReadOnly =
    zio.aws.pinpoint.model.DefaultPushNotificationTemplate.wrap(buildAwsValue())
}
object DefaultPushNotificationTemplate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.DefaultPushNotificationTemplate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.DefaultPushNotificationTemplate =
      zio.aws.pinpoint.model.DefaultPushNotificationTemplate(
        action.map(value => value),
        body.map(value => value),
        sound.map(value => value),
        title.map(value => value),
        url.map(value => value)
      )
    def action: Optional[zio.aws.pinpoint.model.Action]
    def body: Optional[__string]
    def sound: Optional[__string]
    def title: Optional[__string]
    def url: Optional[__string]
    def getAction: ZIO[Any, AwsError, zio.aws.pinpoint.model.Action] =
      AwsError.unwrapOptionField("action", action)
    def getBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("body", body)
    def getSound: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sound", sound)
    def getTitle: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("title", title)
    def getUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.DefaultPushNotificationTemplate
  ) extends zio.aws.pinpoint.model.DefaultPushNotificationTemplate.ReadOnly {
    override val action: Optional[zio.aws.pinpoint.model.Action] =
      zio.aws.core.internal
        .optionalFromNullable(impl.action())
        .map(value => zio.aws.pinpoint.model.Action.wrap(value))
    override val body: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.body())
      .map(value => value: __string)
    override val sound: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.sound())
      .map(value => value: __string)
    override val title: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.title())
      .map(value => value: __string)
    override val url: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.DefaultPushNotificationTemplate
  ): zio.aws.pinpoint.model.DefaultPushNotificationTemplate.ReadOnly =
    new Wrapper(impl)
}
